/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import com.google.common.collect.AbstractIterator;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class RingSearchIterator
extends AbstractIterator<class_2338> {
    private final int range;
    private final class_2338 center;
    private final int yRange;
    private final boolean inflatingY;
    private final float startProgress;
    private int inflate = 0;
    private int startIndex = 0;
    private int index = 0;
    private int maxIndex = 0;
    private final class_2338.class_2339 cursor = new class_2338.class_2339();
    private static final class_2382[] STAGE_MOVES = new class_2382[]{new class_2382(1, 0, 0), new class_2382(0, 0, 1), new class_2382(-1, 0, 0), new class_2382(0, 0, -1)};

    public static Iterable<class_2338> create(class_2338 center, int y, int range, boolean inflatingY) {
        return () -> new RingSearchIterator(center, y, range, inflatingY, 0.0f);
    }

    public static Iterable<class_2338> createWithRandom(class_2338 center, int y, int range, boolean inflatingY, class_5819 rand) {
        float r = rand.method_43057();
        return () -> new RingSearchIterator(center, y, range, inflatingY, r);
    }

    private RingSearchIterator(class_2338 center, int y, int range, boolean inflatingY, float startProgress) {
        this.range = range;
        this.yRange = y;
        this.center = center;
        this.inflatingY = inflatingY;
        this.cursor.method_10103(0, 0, 0);
        this.startProgress = startProgress;
    }

    protected class_2338 computeNext() {
        int max_y;
        if (this.inflate > this.range) {
            return (class_2338)this.endOfData();
        }
        class_2338 ret = this.center.method_10081((class_2382)this.cursor.method_10062());
        int y = this.cursor.method_10264();
        int n = max_y = this.inflatingY ? Math.min(this.yRange, this.inflate) : this.yRange;
        if (y < max_y) {
            this.cursor.method_33098(y >= 0 ? -(y + 1) : -y);
            return ret;
        }
        int stage = this.inflate == 0 ? 0 : this.index / (this.inflate * 2);
        this.cursor.method_30927(STAGE_MOVES[stage]).method_33098(0);
        this.advanceIndex();
        if (this.index == this.startIndex) {
            ++this.inflate;
            this.maxIndex = this.inflate * 2 * 4 - 1;
            this.index = this.startIndex = class_3532.method_15340((int)class_3532.method_15375((float)(this.startProgress * (float)(this.maxIndex + 1))), (int)0, (int)this.maxIndex);
            this.cursor.method_10103(-this.inflate, 0, -this.inflate);
            this.moveToStartIndex();
        }
        return ret;
    }

    private void moveToStartIndex() {
        if (this.startIndex <= 0) {
            return;
        }
        int stage = this.startIndex / (this.inflate * 2);
        int odd_move = this.startIndex % (this.inflate * 2);
        for (int i = 0; i < stage; ++i) {
            this.cursor.method_30927(STAGE_MOVES[i].method_35862(this.inflate * 2));
        }
        this.cursor.method_30927(STAGE_MOVES[stage].method_35862(odd_move));
    }

    private void advanceIndex() {
        ++this.index;
        if (this.index > this.maxIndex) {
            this.index = 0;
        }
    }
}

