/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.forge_imitate.registry;

import com.google.common.collect.Maps;
import doggytalents.common.util.Util;
import doggytalents.forge_imitate.registry.RegistryObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public class DeferredRegister<T> {
    private Map<RegistryObject<T>, Supplier<? extends T>> toResolve = Maps.newHashMap();
    private final List<RegistryObject<T>> orderedView = new ArrayList<RegistryObject<T>>();
    private Supplier<class_2378<T>> registry;
    private String modid = "";

    private DeferredRegister(Supplier<class_2378<T>> reg, String modid) {
        this.registry = reg;
        this.modid = modid;
    }

    public void initAll() {
        for (Map.Entry<RegistryObject<T>, Supplier<T>> entry : this.toResolve.entrySet()) {
            RegistryObject<T> regObj = entry.getKey();
            T value = entry.getValue().get();
            class_2378<T> registry = this.registry.get();
            class_6880.class_6883 holder = class_2378.method_47985(registry, (class_2960)regObj.getId(), value);
            regObj.resolve((class_6880<T>)holder);
        }
    }

    public <T1 extends T> RegistryObject<T1> register(String name, Supplier<T1> sup) {
        RegistryObject regObj = new RegistryObject(Util.getResource(this.modid, name));
        this.toResolve.put(regObj, sup);
        this.orderedView.add(regObj);
        return regObj;
    }

    public Collection<RegistryObject<T>> getEntries() {
        return Collections.unmodifiableList(this.orderedView);
    }

    public static <T> DeferredRegister<T> create(Supplier<class_2378<T>> registry, String modid) {
        return new DeferredRegister<T>(registry, modid);
    }
}

