/*
 * Decompiled with CFR 0.152.
 */
package com.wulian.texturelocaleredirector;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;

public class LangTextureCache {
    private static final Map<ResourceLocation, SoftReference<Boolean>> existsCache = new ConcurrentHashMap<ResourceLocation, SoftReference<Boolean>>();
    private static volatile String currentLanguage = "en_us";

    public static Boolean get(ResourceLocation id) {
        SoftReference<Boolean> ref = existsCache.get(id);
        return ref != null ? ref.get() : null;
    }

    public static void put(ResourceLocation id, boolean exists) {
        existsCache.put(id, new SoftReference<Boolean>(exists));
    }

    public static void clear() {
        existsCache.clear();
    }

    public static void setCurrentLanguage(String lang) {
        currentLanguage = lang;
    }

    public static String getCurrentLanguage() {
        return currentLanguage;
    }

    public static ResourceLocation getLocalizedId(ResourceLocation originalId) {
        String texturePrefix;
        String lang = currentLanguage;
        String originalPath = originalId.m_135815_();
        int index = originalPath.indexOf(texturePrefix = "textures/");
        if (index == -1) {
            return null;
        }
        String before = originalPath.substring(0, index + texturePrefix.length());
        String after = originalPath.substring(index + texturePrefix.length());
        if (after.startsWith(lang + "/")) {
            return null;
        }
        String localizedPath = before + lang + "/" + after;
        return ResourceLocation.m_214293_((String)originalId.m_135827_(), (String)localizedPath);
    }
}

