/*
 * Decompiled with CFR 0.152.
 */
package com.wulian.texturelocaleredirector.mixin;

import com.wulian.texturelocaleredirector.LangTextureCache;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LanguageManager.class})
public abstract class LanguageManagerMixin {
    @Shadow
    private String currentLanguageCode;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(String languageCode, CallbackInfo ci) {
        LangTextureCache.setCurrentLanguage(languageCode);
        LangTextureCache.clear();
    }

    @Inject(method={"setLanguage"}, at={@At(value="HEAD")})
    private void onSetLanguage(String languageCode, CallbackInfo ci) {
        LangTextureCache.setCurrentLanguage(languageCode);
        LangTextureCache.clear();
    }

    @Inject(method={"reload"}, at={@At(value="HEAD")})
    private void onReload(ResourceManager manager, CallbackInfo ci) {
        LangTextureCache.setCurrentLanguage(this.currentLanguageCode);
        LangTextureCache.clear();
    }
}

