/*
 * Decompiled with CFR 0.152.
 */
package com.wulian.texturelocaleredirector.mixin;

import com.wulian.texturelocaleredirector.LangTextureCache;
import com.wulian.texturelocaleredirector.TextureLocaleRedirector;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_3294;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3294.class})
public abstract class NamespaceResourceManagerMixin
implements class_3300 {
    @Inject(method={"method_14488(Ljava/lang/String;Ljava/util/function/Predicate;)Ljava/util/Map;"}, at={@At(value="RETURN")})
    private void onFindResources(String startingPath, Predicate<class_2960> allowedPathPredicate, CallbackInfoReturnable<Map<class_2960, class_3298>> cir) {
        if ("en_us".equals(LangTextureCache.getCurrentLanguage())) {
            return;
        }
        Map originalResources = (Map)cir.getReturnValue();
        if (originalResources.isEmpty()) {
            return;
        }
        HashMap langSpecificResources = new HashMap();
        for (Map.Entry entry : originalResources.entrySet()) {
            class_2960 originalId = (class_2960)entry.getKey();
            class_2960 langId = LangTextureCache.getLocalizedId(originalId);
            if (langId == null) continue;
            Optional<class_3298> langResource = this.checkResourceAndCache(langId, originalId);
            langResource.ifPresent(resource -> langSpecificResources.put(originalId, resource));
        }
        if (!langSpecificResources.isEmpty()) {
            originalResources.putAll(langSpecificResources);
        }
    }

    @Inject(method={"method_14486(Lnet/minecraft/class_2960;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetResource(class_2960 id, CallbackInfoReturnable<Optional<class_3298>> cir) {
        class_2960 langId = LangTextureCache.getLocalizedId(id);
        if (langId == null) {
            return;
        }
        Optional<class_3298> langResource = this.checkResourceAndCache(langId, id);
        if (langResource.isPresent()) {
            cir.setReturnValue(langResource);
        }
    }

    @Unique
    public Optional<class_3298> checkResourceAndCache(class_2960 langId, class_2960 originalId) {
        Boolean cache = LangTextureCache.get(langId);
        if (cache != null) {
            if (cache.booleanValue()) {
                return this.method_14486(langId);
            }
            return Optional.empty();
        }
        Optional langResource = this.method_14486(langId);
        if (langResource.isPresent()) {
            LangTextureCache.put(langId, true);
            TextureLocaleRedirector.LOGGER.info("Redirected resource {} -> {}", (Object)originalId, (Object)langId);
            return langResource;
        }
        LangTextureCache.put(langId, false);
        return Optional.empty();
    }
}

