/*
 * Decompiled with CFR 0.152.
 */
package com.wulian.texturelocaleredirector.mixin;

import com.wulian.texturelocaleredirector.LangTextureCache;
import java.util.function.Consumer;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LanguageManager.class})
public abstract class LanguageManagerMixin {
    @Shadow
    private String currentCode;

    @Inject(method={"<init>(Ljava/lang/String;Ljava/util/function/Consumer;)V"}, at={@At(value="TAIL")})
    private void onInit(String languageCode, Consumer<ClientLanguage> reloadCallback, CallbackInfo ci) {
        LangTextureCache.setCurrentLanguage(languageCode);
        LangTextureCache.clear();
    }

    @Inject(method={"setSelected(Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    private void onSetLanguage(String languageCode, CallbackInfo ci) {
        LangTextureCache.setCurrentLanguage(languageCode);
        LangTextureCache.clear();
    }

    @Inject(method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"}, at={@At(value="HEAD")})
    private void onReload(ResourceManager manager, CallbackInfo ci) {
        LangTextureCache.setCurrentLanguage(this.currentCode);
        LangTextureCache.clear();
    }
}

