/*
 * Decompiled with CFR 0.152.
 */
package com.wulian.texturelocaleredirector.mixin;

import com.wulian.texturelocaleredirector.LangTextureCache;
import com.wulian.texturelocaleredirector.TextureLocaleRedirector;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FallbackResourceManager.class})
public abstract class NamespaceResourceManagerMixin
implements ResourceManager {
    @Inject(method={"listResources(Ljava/lang/String;Ljava/util/function/Predicate;)Ljava/util/Map;"}, at={@At(value="RETURN")})
    private void onFindResources(String startingPath, Predicate<ResourceLocation> allowedPathPredicate, CallbackInfoReturnable<Map<ResourceLocation, Resource>> cir) {
        if ("en_us".equals(LangTextureCache.getCurrentLanguage())) {
            return;
        }
        Map originalResources = (Map)cir.getReturnValue();
        if (originalResources.isEmpty()) {
            return;
        }
        HashMap langSpecificResources = new HashMap();
        for (Map.Entry entry : originalResources.entrySet()) {
            ResourceLocation originalId = (ResourceLocation)entry.getKey();
            ResourceLocation langId = LangTextureCache.getLocalizedId(originalId);
            if (langId == null) continue;
            Optional<Resource> langResource = this.checkResourceAndCache(langId, originalId);
            langResource.ifPresent(resource -> langSpecificResources.put(originalId, resource));
        }
        if (!langSpecificResources.isEmpty()) {
            originalResources.putAll(langSpecificResources);
        }
    }

    @Inject(method={"getResource(Lnet/minecraft/resources/ResourceLocation;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetResource(ResourceLocation id, CallbackInfoReturnable<Optional<Resource>> cir) {
        ResourceLocation langId = LangTextureCache.getLocalizedId(id);
        if (langId == null) {
            return;
        }
        Optional<Resource> langResource = this.checkResourceAndCache(langId, id);
        if (langResource.isPresent()) {
            cir.setReturnValue(langResource);
        }
    }

    @Unique
    public Optional<Resource> checkResourceAndCache(ResourceLocation langId, ResourceLocation originalId) {
        Boolean cache = LangTextureCache.get(langId);
        if (cache != null) {
            if (cache.booleanValue()) {
                return this.getResource(langId);
            }
            return Optional.empty();
        }
        Optional langResource = this.getResource(langId);
        if (langResource.isPresent()) {
            LangTextureCache.put(langId, true);
            TextureLocaleRedirector.LOGGER.info("Redirected resource {} -> {}", (Object)originalId, (Object)langId);
            return langResource;
        }
        LangTextureCache.put(langId, false);
        return Optional.empty();
    }
}

