/*
 * Decompiled with CFR 0.152.
 */
package com.wulian.texturelocaleredirector;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;

public class LangTextureCache {
    private static final Map<class_2960, SoftReference<Boolean>> existsCache = new ConcurrentHashMap<class_2960, SoftReference<Boolean>>();
    private static volatile String currentLanguage = "en_us";

    public static Boolean get(class_2960 id) {
        SoftReference<Boolean> ref = existsCache.get(id);
        return ref != null ? ref.get() : null;
    }

    public static void put(class_2960 id, boolean exists) {
        existsCache.put(id, new SoftReference<Boolean>(exists));
    }

    public static void clear() {
        existsCache.clear();
    }

    public static void setCurrentLanguage(String lang) {
        currentLanguage = lang;
    }

    public static String getCurrentLanguage() {
        return currentLanguage;
    }

    public static class_2960 getLocalizedId(class_2960 originalId) {
        String texturePrefix;
        String lang = currentLanguage;
        String originalPath = originalId.method_12832();
        int index = originalPath.indexOf(texturePrefix = "textures/");
        if (index == -1) {
            return null;
        }
        String before = originalPath.substring(0, index + texturePrefix.length());
        String after = originalPath.substring(index + texturePrefix.length());
        if (after.startsWith(lang + "/")) {
            return null;
        }
        String localizedPath = before + lang + "/" + after;
        return class_2960.method_60655((String)originalId.method_12836(), (String)localizedPath);
    }
}

