/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.smsn.compat;

import dev.aika.smsn.SMSN;
import dev.aika.smsn.annotation.Category;
import dev.aika.smsn.annotation.Ignored;
import dev.aika.smsn.annotation.LoaderSpecific;
import dev.aika.smsn.annotation.MixinList;
import dev.aika.smsn.api.LoaderType;
import dev.aika.smsn.client.gui.ComponentBuilder;
import dev.aika.smsn.client.gui.ConfigMixinList;
import dev.aika.smsn.config.ModConfig;
import dev.aika.smsn.mixin.ModMixinManager;
import dev.aika.smsn.utils.ComponentUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ClothConfigScreen {
    private static final Logger log = SMSN.LOGGER;

    public static ClothConfigScreenBuilder builder() {
        return new ClothConfigScreenBuilder();
    }

    public static class ClothConfigScreenBuilder {
        private static final Marker marker = MarkerFactory.getMarker((String)"ClothConfigScreenBuilder");
        private String modId;
        private class_437 parent;
        private ModConfig config;
        private Class<?> defaultConfigClass;
        private ModMixinManager mixinManager;
        private final List<Runnable> saveRunnables = new ArrayList<Runnable>();
        private final ConfigBuilder builder = ConfigBuilder.create();
        private ComponentBuilder componentBuilder;

        private ClothConfigScreenBuilder() {
        }

        public class_437 build() {
            Field[] fields;
            this.builder.setParentScreen(this.parent).setSavingRunnable(() -> this.saveRunnables.forEach(Runnable::run)).setTitle((class_2561)class_2561.method_43471((String)("config." + this.modId + ".@title")));
            this.saveRunnables.add(this.config::save);
            this.componentBuilder = new ComponentBuilder(this.builder.entryBuilder(), this.config).setModId(this.modId).setDefaultConfigObject(Objects.requireNonNullElseGet(this.defaultConfigClass, () -> this.config.getClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            for (Field field : fields = this.config.getClass().getDeclaredFields()) {
                this.addEntry(field);
            }
            this.builder.transparentBackground();
            return this.builder.build();
        }

        private void addEntry(Field field) {
            if (this.isIgnored(field)) {
                return;
            }
            String categoryKey = this.getCategoryKey(field);
            ConfigCategory configCategory = this.getConfigCategory(categoryKey);
            if (field.getAnnotation(MixinList.class) != null) {
                if (this.mixinManager == null) {
                    log.warn(marker, "ModMixinManager not set");
                    return;
                }
                ConfigMixinList mixinList = new ConfigMixinList(this.modId, this.mixinManager, this.componentBuilder, field, configCategory);
                this.saveRunnables.add(mixinList::save);
                mixinList.create();
                return;
            }
            Class<?> fieldType = field.getType();
            if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
                configCategory.addEntry(this.componentBuilder.switchBuilder(field, categoryKey).build());
            } else if (fieldType.isEnum()) {
                configCategory.addEntry(this.componentBuilder.enumSelectorBuilder(field, categoryKey, fieldType).build());
            } else {
                configCategory.addEntry(this.unsupportedDescription(fieldType).build());
                log.warn(marker, "Unsupported field type: {}", fieldType);
            }
        }

        private boolean isIgnored(Field field) {
            if (Modifier.isFinal(field.getModifiers())) {
                return true;
            }
            if (field.getAnnotation(Ignored.class) != null) {
                return true;
            }
            LoaderSpecific loaderAnnotation = field.getAnnotation(LoaderSpecific.class);
            if (loaderAnnotation != null) {
                return !List.of(loaderAnnotation.value()).contains((Object)LoaderType.getCurrentLoader());
            }
            return false;
        }

        private String getCategoryKey(Field field) {
            MixinList mixinList = field.getDeclaredAnnotation(MixinList.class);
            Category categoryAnnotation = mixinList != null ? mixinList.value() : field.getAnnotation(Category.class);
            return categoryAnnotation != null ? categoryAnnotation.value() : "general";
        }

        private ConfigCategory getConfigCategory(String categoryKey) {
            ConfigCategory category = this.builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)("config." + this.modId + "." + categoryKey)));
            String descriptionKey = String.format("config.%s.%s.@description", this.modId, categoryKey);
            if (ComponentUtils.hasTranslation(descriptionKey)) {
                category.setDescription(new class_5348[]{class_2561.method_43471((String)descriptionKey)});
            }
            return category;
        }

        private FieldBuilder<?, ?, ?> unsupportedDescription(Class<?> clazz) {
            return this.componentBuilder.getEntryBuilder().startTextDescription((class_2561)class_2561.method_43469((String)String.format("config.%s.unsupported.description", this.modId), (Object[])new Object[]{clazz.getSimpleName()})).setTooltip(new class_2561[]{class_2561.method_43470((String)clazz.getName())});
        }

        @Generated
        public ClothConfigScreenBuilder setModId(String modId) {
            this.modId = modId;
            return this;
        }

        @Generated
        public ClothConfigScreenBuilder setParent(class_437 parent) {
            this.parent = parent;
            return this;
        }

        @Generated
        public ClothConfigScreenBuilder setConfig(ModConfig config) {
            this.config = config;
            return this;
        }

        @Generated
        public ClothConfigScreenBuilder setDefaultConfigClass(Class<?> defaultConfigClass) {
            this.defaultConfigClass = defaultConfigClass;
            return this;
        }

        @Generated
        public ClothConfigScreenBuilder setMixinManager(ModMixinManager mixinManager) {
            this.mixinManager = mixinManager;
            return this;
        }
    }
}

