/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.smsn.client.gui;

import dev.aika.smsn.client.gui.components.AbstractComponentBuilder;
import dev.aika.smsn.client.gui.components.DoubleInputBuilder;
import dev.aika.smsn.client.gui.components.EnumSelectorBuilder;
import dev.aika.smsn.client.gui.components.FloatInputBuilder;
import dev.aika.smsn.client.gui.components.IntInputBuilder;
import dev.aika.smsn.client.gui.components.StringInputBuilder;
import dev.aika.smsn.client.gui.components.SwitchBuilder;
import java.lang.reflect.Field;
import lombok.Generated;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ComponentBuilder {
    protected final ConfigEntryBuilder entryBuilder;
    protected final Object configObject;
    protected Object defaultConfigObject;
    protected String modId;

    public ComponentBuilder(ConfigEntryBuilder entryBuilder, Object configObject) {
        this.entryBuilder = entryBuilder;
        this.configObject = configObject;
    }

    private <T extends AbstractComponentBuilder<?>> T createBuilder(String category, T builder) {
        builder.setModId(this.modId).setCategory(category);
        if (this.defaultConfigObject != null) {
            builder.setDefaultConfigObject(this.defaultConfigObject);
        }
        return builder;
    }

    public SwitchBuilder switchBuilder(Field field, String category) {
        return this.createBuilder(category, new SwitchBuilder(this.entryBuilder, this.configObject, field));
    }

    public <E extends Enum<?>> EnumSelectorBuilder<?> enumSelectorBuilder(Field field, String category, Class<E> enumClass) {
        return this.createBuilder(category, new EnumSelectorBuilder<E>(this.entryBuilder, this.configObject, enumClass, field));
    }

    public StringInputBuilder stringInputBuilder(Field field, String category) {
        return this.createBuilder(category, new StringInputBuilder(this.entryBuilder, this.configObject, field));
    }

    public FloatInputBuilder floatInputBuilder(Field field, String category) {
        return this.createBuilder(category, new FloatInputBuilder(this.entryBuilder, this.configObject, field));
    }

    public IntInputBuilder intInputBuilder(Field field, String category) {
        return this.createBuilder(category, new IntInputBuilder(this.entryBuilder, this.configObject, field));
    }

    public DoubleInputBuilder doubleInputBuilder(Field field, String category) {
        return this.createBuilder(category, new DoubleInputBuilder(this.entryBuilder, this.configObject, field));
    }

    @Generated
    public ConfigEntryBuilder getEntryBuilder() {
        return this.entryBuilder;
    }

    @Generated
    public Object getConfigObject() {
        return this.configObject;
    }

    @Generated
    public ComponentBuilder setDefaultConfigObject(Object defaultConfigObject) {
        this.defaultConfigObject = defaultConfigObject;
        return this;
    }

    @Generated
    public String getModId() {
        return this.modId;
    }

    @Generated
    public ComponentBuilder setModId(String modId) {
        this.modId = modId;
        return this;
    }
}

