/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.smsn.client.gui;

import dev.aika.smsn.SMSNPlatform;
import dev.aika.smsn.client.gui.ComponentBuilder;
import dev.aika.smsn.mixin.ModMixinInfo;
import dev.aika.smsn.mixin.ModMixinManager;
import dev.aika.smsn.utils.ComponentUtils;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ConfigMixinList {
    private final ComponentBuilder componentBuilder;
    private final Field field;
    private final ConfigCategory category;
    private final Lock lock = new ReentrantLock();
    private Set<String> disabledMixins;

    public ConfigMixinList(ComponentBuilder componentBuilder, Field field, ConfigCategory category) {
        this.componentBuilder = componentBuilder;
        this.field = field;
        this.category = category;
        this.init();
    }

    private void init() {
        this.field.setAccessible(true);
        this.disabledMixins = (Set)this.field.get(this.componentBuilder.getConfigObject());
    }

    private boolean isEnable(String mixinClass) {
        return !this.disabledMixins.contains(mixinClass);
    }

    private void setEnable(String mixinClass, boolean enable) {
        this.lock.lock();
        if (enable) {
            this.disabledMixins.remove(mixinClass);
        } else {
            this.disabledMixins.add(mixinClass);
        }
        this.lock.unlock();
    }

    public void save() {
        this.lock.lock();
        this.field.setAccessible(true);
        this.field.set(this.componentBuilder.getConfigObject(), this.disabledMixins);
        this.lock.unlock();
    }

    public void create() {
        ConfigEntryBuilder builder = this.componentBuilder.getEntryBuilder();
        Set<ModMixinInfo> infos = ModMixinManager.getMixinInfos();
        for (ModMixinInfo info : infos) {
            MutableComponent subTitle = ComponentUtils.createWithFallback(String.format("smsn.mod.%s", info.getModid()), "modmenu.nameTranslation." + info.getModid(), ComponentUtils.literal(SMSNPlatform.getModName(info.getModid())), ComponentUtils.literal(info.getModid())).m_130948_(Style.f_131099_.m_131157_(ChatFormatting.BOLD));
            if (SMSNPlatform.isModLoaded(info.getModid())) {
                subTitle.m_7220_((Component)Component.m_237115_((String)"config.smsn.mixins.modLoaded"));
            }
            this.category.addEntry((AbstractConfigListEntry)builder.startTextDescription((Component)subTitle).setTooltip(new Component[]{Component.m_237110_((String)"config.smsn.mixins.modIdTooptip", (Object[])new Object[]{info.getModid()})}).build());
            for (String mixinClass : info.getMixinClasses()) {
                String shortName = mixinClass.replaceFirst("dev.aika.smsn.", "");
                this.category.addEntry((AbstractConfigListEntry)builder.startBooleanToggle((Component)Component.m_237113_((String)shortName), this.isEnable(mixinClass)).setSaveConsumer(v -> this.setEnable(mixinClass, (boolean)v)).setYesNoTextSupplier(v -> Component.m_237115_((String)String.format("config.smsn.@switch.%s", v != false ? "enable" : "disabled"))).setTooltip(new Component[]{Component.m_237113_((String)mixinClass)}).requireRestart().build());
            }
        }
    }
}

