/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.smsn.mixin;

import dev.aika.smsn.SMSN;
import dev.aika.smsn.SMSNPlatform;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class ModMixinInfo
implements Comparable<ModMixinInfo> {
    private final String modid;
    private final List<String> mixinClasses;
    private final boolean isModLoaded;

    private ModMixinInfo(String modid, List<String> mixinClasses) {
        this.modid = modid;
        this.mixinClasses = mixinClasses;
        this.isModLoaded = SMSNPlatform.isModLoaded(modid);
    }

    public static ModMixinInfo create(String modid, String ... mixinClasses) {
        return new ModMixinInfo(modid, List.of(mixinClasses));
    }

    @Override
    public int compareTo(@NotNull ModMixinInfo o) {
        if (this.modid.hashCode() < o.modid.hashCode()) {
            return -1;
        }
        if (this.modid.hashCode() == o.modid.hashCode()) {
            return 0;
        }
        return 1;
    }

    public boolean shouldApply(String mixinClassName) {
        return this.isModLoaded && !SMSN.CONFIG.disabledMixins.contains(mixinClassName);
    }

    @Generated
    public String getModid() {
        return this.modid;
    }

    @Generated
    public List<String> getMixinClasses() {
        return this.mixinClasses;
    }

    @Generated
    public boolean isModLoaded() {
        return this.isModLoaded;
    }
}

