/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.smsn.client.gui;

import dev.aika.smsn.annotation.MixinList;
import dev.aika.smsn.api.ModPlatform;
import dev.aika.smsn.client.gui.ComponentBuilder;
import dev.aika.smsn.mixin.ModMixinInfo;
import dev.aika.smsn.mixin.ModMixinManager;
import dev.aika.smsn.utils.ComponentUtils;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ConfigMixinList {
    private final ComponentBuilder componentBuilder;
    private final Field field;
    private final ConfigCategory category;
    private final String modId;
    private final ModMixinManager mixinManager;
    private final Lock lock = new ReentrantLock();
    private Set<String> disabledMixins;

    public ConfigMixinList(String modId, ModMixinManager mixinManager, ComponentBuilder componentBuilder, Field field, ConfigCategory category) {
        this.modId = modId;
        this.mixinManager = mixinManager;
        this.componentBuilder = componentBuilder;
        this.field = field;
        this.category = category;
        this.init();
    }

    private void init() {
        this.field.setAccessible(true);
        this.disabledMixins = (Set)this.field.get(this.componentBuilder.getConfigObject());
    }

    private boolean isEnable(String mixinClass) {
        return !this.disabledMixins.contains(mixinClass);
    }

    private void setEnable(String mixinClass, boolean enable) {
        this.lock.lock();
        if (enable) {
            this.disabledMixins.remove(mixinClass);
        } else {
            this.disabledMixins.add(mixinClass);
        }
        this.lock.unlock();
    }

    public void save() {
        this.lock.lock();
        this.field.setAccessible(true);
        this.field.set(this.componentBuilder.getConfigObject(), this.disabledMixins);
        this.lock.unlock();
    }

    public void create() {
        MixinList annotation = this.field.getAnnotation(MixinList.class);
        ConfigEntryBuilder builder = this.componentBuilder.getEntryBuilder();
        Set<ModMixinInfo> infos = this.mixinManager.getMixinInfos();
        for (ModMixinInfo info : infos) {
            MutableComponent subTitle = Objects.requireNonNull(ComponentUtils.createWithFallback(String.format("%s.mod.%s", this.modId, info.getModId()), "modmenu.nameTranslation." + info.getModId(), ComponentUtils.literal(ModPlatform.getModName(info.getModId())), ComponentUtils.literal(info.getModId()))).withStyle(Style.EMPTY.applyFormat(ChatFormatting.BOLD));
            if (ModPlatform.isModLoaded(info.getModId())) {
                subTitle.append((Component)Component.translatable((String)String.format("config.%s.mixins.modLoaded", this.modId)));
            }
            this.category.addEntry((AbstractConfigListEntry)builder.startTextDescription((Component)subTitle).setTooltip(new Component[]{Component.translatable((String)String.format("config.%s.mixins.modIdTooltip", this.modId), (Object[])new Object[]{info.getModId()})}).build());
            for (String mixinClass : info.getMixinClasses()) {
                String shortName = mixinClass.replaceFirst(annotation.prefix(), "");
                this.category.addEntry((AbstractConfigListEntry)builder.startBooleanToggle((Component)Component.literal((String)shortName), this.isEnable(mixinClass)).setSaveConsumer(v -> this.setEnable(mixinClass, (boolean)v)).setYesNoTextSupplier(v -> Component.translatable((String)String.format("config.%s.@switch.%s", this.modId, v != false ? "enable" : "disabled"))).setTooltip(new Component[]{Component.literal((String)mixinClass)}).requireRestart().build());
            }
        }
    }
}

