/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.wildbows.item;

import java.util.List;
import net.mcreator.wildbows.entity.ShockArrowEntity;
import net.mcreator.wildbows.procedures.ShockArrowCheckProcedure;
import net.mcreator.wildbows.procedures.ShockInventoryTickProcedure;
import net.mcreator.wildbows.procedures.ShockRightClickProcedure;
import net.mcreator.wildbows.procedures.ShockStoppedUsingProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class WildShockBowItem
extends Item {
    public WildShockBowItem() {
        super(new Item.Properties().durability(1763).rarity(Rarity.COMMON));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getEnchantmentValue() {
        return 20;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 128000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_0"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_1"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_2"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_3"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_4"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_5"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_6"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_7"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_8"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_9"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_10"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_11"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_12"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_13"));
        list.add((Component)Component.translatable((String)"item.wild_bows.wild_shock_bow.description_14"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = InteractionResultHolder.fail((Object)entity.getItemInHand(hand));
        if (ShockArrowCheckProcedure.execute((Entity)entity) && (entity.getAbilities().instabuild || this.findAmmo(entity) != ItemStack.EMPTY)) {
            ar = InteractionResultHolder.success((Object)entity.getItemInHand(hand));
            entity.startUsingItem(hand);
        }
        ShockRightClickProcedure.execute((Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        ShockInventoryTickProcedure.execute(entity, itemstack);
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float pullingPower = BowItem.getPowerForTime((int)(this.getUseDuration(itemstack, (LivingEntity)player) - time));
            if ((double)pullingPower < 0.1) {
                return;
            }
            ItemStack stack = this.findAmmo((Player)player);
            if (player.getAbilities().instabuild || stack != ItemStack.EMPTY) {
                ShockArrowEntity projectile = ShockArrowEntity.shoot(world, entity, world.getRandom(), pullingPower);
                itemstack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
                if (player.getAbilities().instabuild) {
                    projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (stack.isDamageableItem()) {
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        stack.hurtAndBreak(1, serverLevel, player, _stkprov -> {});
                    }
                } else {
                    stack.shrink(1);
                }
                ShockStoppedUsingProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
            }
        }
    }

    private ItemStack findAmmo(Player player) {
        ItemStack stack = ProjectileWeaponItem.getHeldProjectile((LivingEntity)player, e -> e.getItem() == ShockArrowEntity.PROJECTILE_ITEM.getItem());
        if (stack == ItemStack.EMPTY) {
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                ItemStack teststack = (ItemStack)player.getInventory().items.get(i);
                if (teststack == null || teststack.getItem() != ShockArrowEntity.PROJECTILE_ITEM.getItem()) continue;
                stack = teststack;
                break;
            }
        }
        return stack;
    }
}

