/*
 * Decompiled with CFR 0.152.
 */
package com.miwo4ka.boneblocks.core.block;

import com.miwo4ka.boneblocks.init.ModBlocks;
import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BigSkullBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<BigSkullBlock> CODEC = BigSkullBlock.simpleCodec(BigSkullBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private BlockPattern skeletonFull;

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public BigSkullBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{FACING});
    }

    public void onPlace(BlockState $$0, Level $$1, BlockPos $$2, BlockState $$3, boolean $$4) {
        if (!$$3.is($$0.getBlock())) {
            this.trySpawnSkeleton($$1, $$2);
        }
    }

    private void trySpawnSkeleton(Level $$0, BlockPos $$1) {
        Entity $$3;
        BlockPattern.BlockPatternMatch $$2 = this.getOrCreateSkeletonFull().find((LevelReader)$$0, $$1);
        if ($$2 != null && ($$3 = EntityType.SKELETON.create($$0)) != null) {
            BigSkullBlock.spawnSkeletonInWorld($$0, $$2, $$3, $$2.getBlock(0, 2, 0).getPos());
        }
    }

    private BlockPattern getOrCreateSkeletonFull() {
        if (this.skeletonFull == null) {
            this.skeletonFull = BlockPatternBuilder.start().aisle(new String[]{"^", "#", "#"}).where('^', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)ModBlocks.BIG_SKELETON_SKULL.value())))).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)ModBlocks.FRAGILE_BONE_BLOCK.value())))).build();
        }
        return this.skeletonFull;
    }

    private static void spawnSkeletonInWorld(Level level, BlockPattern.BlockPatternMatch blockPatternMatch, Entity entity, BlockPos pos) {
        BigSkullBlock.clearPatternBlocks(level, blockPatternMatch);
        entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.05, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
        level.addFreshEntity(entity);
        for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(5.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(player, entity);
        }
        BigSkullBlock.updatePatternBlocks(level, blockPatternMatch);
    }

    public static void clearPatternBlocks(Level level, BlockPattern.BlockPatternMatch blockPatternMatch) {
        for (int i = 0; i < blockPatternMatch.getWidth(); ++i) {
            for (int j = 0; j < blockPatternMatch.getHeight(); ++j) {
                BlockInWorld block = blockPatternMatch.getBlock(i, j, 0);
                level.setBlock(block.getPos(), Blocks.AIR.defaultBlockState(), 2);
                level.levelEvent(2001, block.getPos(), Block.getId((BlockState)block.getState()));
            }
        }
    }

    public static void updatePatternBlocks(Level level, BlockPattern.BlockPatternMatch blockPatternMatch) {
        for (int i = 0; i < blockPatternMatch.getWidth(); ++i) {
            for (int j = 0; j < blockPatternMatch.getHeight(); ++j) {
                BlockInWorld $$4 = blockPatternMatch.getBlock(i, j, 0);
                level.blockUpdated($$4.getPos(), Blocks.AIR);
            }
        }
    }
}

