package com.boyonk.musicsync;

import com.boyonk.musicsync.network.packet.c2s.play.MusicTrackerUpdateC2SPacket;
import com.boyonk.musicsync.network.packet.s2c.play.PlayMusicS2CPacket;
import com.boyonk.musicsync.network.packet.s2c.play.StopMusicS2CPacket;
import com.boyonk.musicsync.server.command.MusicCommand;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_5195;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class MusicSync implements ModInitializer {

	public static final String NAMESPACE = "music_sync";

	public static final class_9139<class_9129, class_5195> MUSIC_SOUND_PACKET_CODEC = class_9135.method_56896(class_5195.field_24627);

	@Override
	public void onInitialize() {
		CommandRegistrationCallback.EVENT.register(MusicCommand::register);

		PayloadTypeRegistry.playC2S().register(MusicTrackerUpdateC2SPacket.ID, MusicTrackerUpdateC2SPacket.CODEC);

		PayloadTypeRegistry.playS2C().register(PlayMusicS2CPacket.ID, PlayMusicS2CPacket.CODEC);
		PayloadTypeRegistry.playS2C().register(StopMusicS2CPacket.ID, StopMusicS2CPacket.CODEC);

		ServerPlayNetworking.registerGlobalReceiver(MusicTrackerUpdateC2SPacket.ID, (payload, context) -> ((ServerMusicTrackerHolder) context.player().method_51469().method_8503()).getMusicTracker().onUpdate(payload, context.player()));

		ServerTickEvents.END_SERVER_TICK.register((server) -> ((ServerMusicTrackerHolder) server).getMusicTracker().tick());
	}
}
