package com.boyonk.musicsync;

import com.boyonk.musicsync.network.packet.c2s.play.MusicTrackerUpdateC2SPacket;
import com.boyonk.musicsync.network.packet.s2c.play.PlayMusicS2CPacket;
import com.boyonk.musicsync.network.packet.s2c.play.StopMusicS2CPacket;
import com.mojang.serialization.Codec;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_5195;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class ServerMusicTracker {

	private static final TrackerData DEFAULT_TRACKING_DATA = new TrackerData() {

		@Override
		public Optional<class_5195> type() {
			return Optional.empty();
		}

		@Override
		public boolean playing() {
			return false;
		}
	};
	public static final int DEFAULT_TIME_UNTIL_NEXT_SONG = 100;

	private final MinecraftServer server;

	private final Map<class_3222, TrackerData> trackerData = new HashMap<>();

	@Nullable
	private class_6880<class_3414> current;
	private int timeUntilNextSong = DEFAULT_TIME_UNTIL_NEXT_SONG;

	private final class_5819 random = class_5819.method_43047();

	private boolean enabled = true;
	private MusicFrequency musicFrequency = MusicFrequency.DEFAULT;

	public ServerMusicTracker(MinecraftServer server) {
		this.server = server;
	}

	public void tick() {
		if (!this.enabled) {
			if (!this.trackerData.isEmpty()) this.trackerData.clear();
			return;
		}

		if (!this.refreshPlayers()) return;


		class_5195 type = this.getMusicType();
		if (type == null) return;

		if (this.current != null) {
			if (!type.comp_4358().method_40230().equals(this.current.method_40230()) && type.comp_4361()) {
				this.stop(class_3532.method_15395(this.random, 0, type.comp_4359() / 2));
			}
			if (!this.isPlaying()) {
				this.stop(Math.min(this.timeUntilNextSong, this.musicFrequency.getDelayBeforePlaying(type, this.random)));
			}
		}

		this.timeUntilNextSong = Math.min(this.timeUntilNextSong, type.comp_4360());
		this.timeUntilNextSong--;

		if (this.current == null && this.timeUntilNextSong <= 0) {
			this.play(type);
		}
	}

	public void enable() {
		if (!this.enabled) this.enabled = true;
	}

	public void disable() {
		if (this.enabled) this.enabled = false;
	}

	protected void stop() {
		this.stop(DEFAULT_TIME_UNTIL_NEXT_SONG);
	}

	public void stop(int timeUntilNextSong) {
		this.timeUntilNextSong = timeUntilNextSong;

		if (this.current != null) {
			StopMusicS2CPacket packet = new StopMusicS2CPacket();
			this.server.method_3760().method_14571().forEach(player -> ServerPlayNetworking.send(player, packet));

			this.current = null;
		}
	}

	protected void play(class_5195 type) {
		this.timeUntilNextSong = Integer.MAX_VALUE;

		this.current = type.comp_4358();

		PlayMusicS2CPacket packet = new PlayMusicS2CPacket(this.current, this.random.method_43055());
		this.server.method_3760().method_14571().forEach(player -> ServerPlayNetworking.send(player, packet));
	}

	/**
	 * @return whether there are any players online
	 */
	protected boolean refreshPlayers() {
		Set<class_3222> currentPlayers = new HashSet<>(this.server.method_3760().method_14571());

		boolean anyPlayers = !currentPlayers.isEmpty();

		Set<class_3222> trackedPlayers = trackerData.keySet();

		if (currentPlayers.equals(trackedPlayers)) return anyPlayers;

		List<class_3222> toAdd = currentPlayers.stream().filter(player -> !trackedPlayers.contains(player)).toList();
		List<class_3222> toRemove = trackedPlayers.stream().filter(player -> !currentPlayers.contains(player)).toList();

		toAdd.forEach(player -> this.trackerData.put(player, DEFAULT_TRACKING_DATA));
		toRemove.forEach(this.trackerData::remove);

		return anyPlayers;
	}

	@Nullable
	protected class_5195 getMusicType() {
		List<class_5195> types = this.trackerData.values().stream().map(TrackerData::type).filter(Optional::isPresent).map(Optional::get).toList();

		if (types.isEmpty()) return null;

		List<class_5195> shouldReplaceTypes = types.stream().filter(class_5195::comp_4361).toList();

		if (!shouldReplaceTypes.isEmpty()) {
			return shouldReplaceTypes.get(this.random.method_43048(shouldReplaceTypes.size()));
		}

		return types.get(this.random.method_43048(types.size()));
	}

	protected boolean isPlaying() {
		return !this.trackerData.isEmpty() && this.trackerData.values().stream().anyMatch(TrackerData::playing);
	}


	public void onUpdate(MusicTrackerUpdateC2SPacket packet, class_3222 player) {
		this.trackerData.put(player, packet);
	}

	public interface TrackerData {

		Optional<class_5195> type();

		boolean playing();
	}

	public enum MusicFrequency implements class_3542 {
		DEFAULT("default", 20),
		FREQUENT("frequent", 10),
		CONSTANT("constant", 0);

		public static final Codec<MusicFrequency> CODEC = class_3542.method_28140(MusicFrequency::values);

		private final String name;
		private final int index;
		private final int delayBetweenTracks;

		MusicFrequency(String name, int index) {
			this.name = name;
			this.index = index;
			this.delayBetweenTracks = index * 1200;
		}

		int getDelayBeforePlaying(@Nullable class_5195 music, class_5819 random) {
			if (music == null) {
				return this.delayBetweenTracks;
			}
			if (this == CONSTANT) {
				return 100;
			}
			int i = Math.min(music.comp_4359(), this.delayBetweenTracks);
			int j = Math.min(music.comp_4360(), this.delayBetweenTracks);
			return class_3532.method_15395(random, i, j);
		}

		@Override
		public String method_15434() {
			return this.name;
		}
	}

}

