package com.boyonk.musicsync.client.mixin;

import com.boyonk.musicsync.client.ClientMusicTracker;
import com.boyonk.musicsync.client.TemporaryRandomSetter;
import com.boyonk.musicsync.network.packet.c2s.play.MusicTrackerUpdateC2SPacket;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10383;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1142;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5195;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.client.sound.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;
import java.util.Optional;

@Mixin(class_1142.class)
public abstract class MixinMusicTracker implements ClientMusicTracker {

	@Unique
	private @Nullable class_5195 musicsync$type = null;

	@Unique
	private boolean musicsync$playing = false;

	@Unique
	private boolean musicsync$dirty = true;

	@Shadow
	@Final
	private class_310 client;

	@Shadow
	private @Nullable class_1113 current;

	@Shadow
	private int timeUntilNextSong;

	@Shadow protected abstract boolean canFadeTowardsVolume(float volume);

	@Shadow private float volume;

	@Shadow private boolean shownToast;

	@Inject(method = "tick", at = @At("HEAD"), cancellable = true)
	void tick(CallbackInfo ci) {
		if (this.isInGame()) {
			class_10383 instance = this.client.method_1544();
			this.setType(instance.comp_3344());

			if(this.volume != instance.comp_3345()) this.canFadeTowardsVolume(instance.comp_3345());

			if (this.current != null) {
				if (!this.client.method_1483().method_4877(this.current)) {
					this.current = null;
				}
			}

			this.setPlaying(this.current != null);

			this.popDirty();

			ci.cancel();
		}
	}

	@Unique
	private void setType(@Nullable class_5195 type) {
		if (!Objects.equals(type, this.musicsync$type)) {
			this.musicsync$type = type;
			this.markDirty();
		}
	}

	private void setPlaying(boolean playing) {
		if (playing != this.musicsync$playing) {
			this.musicsync$playing = playing;
			this.markDirty();
		}
	}

	private void markDirty() {
		this.musicsync$dirty = true;
	}

	private void popDirty() {
		if (!this.musicsync$dirty) return;

		this.musicsync$dirty = false;

		MusicTrackerUpdateC2SPacket packet = new MusicTrackerUpdateC2SPacket(Optional.ofNullable(this.musicsync$type), this.musicsync$playing);
		ClientPlayNetworking.send(packet);
	}

	private boolean isInGame() {
		return class_310.method_1551().method_1562() != null;
	}

	@Override
	public void play(@Nullable class_6880<class_3414> event, long seed) {
		if (event == null) return;

		this.current = class_1109.method_4759(event.comp_349(), this.volume);
		((TemporaryRandomSetter) this.current).setTemporaryRandom(class_5819.method_43049(seed));
		switch (this.client.method_1483().method_4873(this.current)) {
			case field_60954: {
				this.client.method_1566().method_71815();
				this.shownToast = true;
				break;
			}
			case field_60955: {
				this.shownToast = false;
			}
		}

		this.timeUntilNextSong = Integer.MAX_VALUE;
	}
}
