package com.boyonk.musicsync.server.command;

import com.boyonk.musicsync.ServerMusicTracker;
import com.boyonk.musicsync.ServerMusicTrackerHolder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class MusicCommand {
	public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 environment) {
		dispatcher.register(method_9247("music")
				.requires(source -> source.method_9259(3))
				.then(method_9247("reset")
						.executes(ctx -> executeReset(ctx.getSource(), ServerMusicTracker.DEFAULT_TIME_UNTIL_NEXT_SONG))
						.then(method_9244("delay", IntegerArgumentType.integer(0))
								.executes(ctx -> executeReset(ctx.getSource(), IntegerArgumentType.getInteger(ctx, "delay")))
						)
				)
				.then(method_9247("enable")
						.executes(ctx -> executeEnable(ctx.getSource()))
				)
				.then(method_9247("disable")
						.executes(ctx -> executeDisable(ctx.getSource()))
				)
		);
	}


	private static int executeReset(class_2168 source, int delay) {
		ServerMusicTracker musicTracker = ((ServerMusicTrackerHolder) source.method_9211()).getMusicTracker();

		musicTracker.stop(delay);
		return 1;
	}

	private static int executeEnable(class_2168 source) {
		ServerMusicTracker musicTracker = ((ServerMusicTrackerHolder) source.method_9211()).getMusicTracker();

		musicTracker.enable();

		return 1;
	}

	private static int executeDisable(class_2168 source) {
		ServerMusicTracker musicTracker = ((ServerMusicTrackerHolder) source.method_9211()).getMusicTracker();

		musicTracker.disable();
		return 0;
	}


}
