/*
 * Decompiled with CFR 0.152.
 */
package jhuanglululu.gimmethat.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import jhuanglululu.gimmethat.command.argument.AbstractArgumentType;
import jhuanglululu.gimmethat.command.argument.enums.SherdEnum;
import jhuanglululu.gimmethat.utility.Out;

public class SherdArgument
extends AbstractArgumentType<SherdEnum> {
    public SherdEnum parse(StringReader stringReader) throws CommandSyntaxException {
        try {
            String string = stringReader.readString();
            if (string.equals("random")) {
                return SherdEnum.getRandom();
            }
            Out<SherdEnum> sherd = new Out<SherdEnum>();
            if (SherdEnum.getByName(string, sherd)) {
                return sherd.get();
            }
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().create((Object)"Invalid type, expected none, random or any sherd");
        }
        catch (Exception e) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().create((Object)"Invalid type, expected none, random or any sherd");
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        SherdArgument.pushBuilder(builder);
        SherdArgument.addSuggestion("random");
        SherdArgument.addSuggestion("none");
        for (SherdEnum sherd : SherdEnum.values()) {
            SherdArgument.addSuggestion(sherd.name().toLowerCase());
        }
        return builder.buildFuture();
    }
}

