/*
 * Decompiled with CFR 0.152.
 */
package jhuanglululu.gimmethat.command.argument.enums;

import java.util.List;
import java.util.Random;
import jhuanglululu.gimmethat.command.argument.enums.PlantTypeEnum;
import jhuanglululu.gimmethat.utility.EnumMultiMap;
import jhuanglululu.gimmethat.utility.Out;
import net.minecraft.class_1792;
import net.minecraft.class_1802;

public enum PlantEnum {
    DANDELION(PlantTypeEnum.FLOWER, class_1802.field_8491),
    POPPY(PlantTypeEnum.FLOWER, class_1802.field_8880),
    BLUE_ORCHID(PlantTypeEnum.FLOWER, class_1802.field_17499),
    ALLIUM(PlantTypeEnum.FLOWER, class_1802.field_17500),
    AZURE_BLUET(PlantTypeEnum.FLOWER, class_1802.field_17501),
    RED_TULIP(PlantTypeEnum.FLOWER, class_1802.field_17502),
    ORANGE_TULIP(PlantTypeEnum.FLOWER, class_1802.field_17509),
    WHITE_TULIP(PlantTypeEnum.FLOWER, class_1802.field_17510),
    PINK_TULIP(PlantTypeEnum.FLOWER, class_1802.field_17511),
    OXEYE_DAISY(PlantTypeEnum.FLOWER, class_1802.field_17512),
    CORNFLOWER(PlantTypeEnum.FLOWER, class_1802.field_17513),
    LILY_OF_THE_VALLEY(PlantTypeEnum.FLOWER, class_1802.field_17514),
    WITHER_ROSE(PlantTypeEnum.FLOWER, class_1802.field_17515),
    TORCHFLOWER(PlantTypeEnum.FLOWER, class_1802.field_42695),
    CLOSED_EYEBLOSSOM(PlantTypeEnum.FLOWER, class_1802.field_55036),
    OPENED_EYEBLOSSOM(PlantTypeEnum.FLOWER, class_1802.field_55035),
    OAK(PlantTypeEnum.SAPLING, class_1802.field_17535),
    SPRUCE(PlantTypeEnum.SAPLING, class_1802.field_17536),
    BIRCH(PlantTypeEnum.SAPLING, class_1802.field_17537),
    JUNGLE(PlantTypeEnum.SAPLING, class_1802.field_17538),
    ACACIA(PlantTypeEnum.SAPLING, class_1802.field_17539),
    DARK_OAK(PlantTypeEnum.SAPLING, class_1802.field_17540),
    AZALEA(PlantTypeEnum.SAPLING, class_1802.field_28650),
    FLOWERING_AZALEA(PlantTypeEnum.SAPLING, class_1802.field_28651),
    MANGROVE(PlantTypeEnum.SAPLING, class_1802.field_37508),
    CHERRY(PlantTypeEnum.SAPLING, class_1802.field_42688),
    PALE_OAK(PlantTypeEnum.SAPLING, class_1802.field_54602),
    RED_MUSHROOM(PlantTypeEnum.MUSHROOM, class_1802.field_17517),
    BROWN_MUSHROOM(PlantTypeEnum.MUSHROOM, class_1802.field_17516),
    CRIMSON_FUNGUS(PlantTypeEnum.MUSHROOM, class_1802.field_21987),
    WARPED_FUNGUS(PlantTypeEnum.MUSHROOM, class_1802.field_21988),
    CRIMSON_ROOTS(PlantTypeEnum.BUSH, class_1802.field_21989),
    WARPED_ROOTS(PlantTypeEnum.BUSH, class_1802.field_21990),
    FERN(PlantTypeEnum.BUSH, class_1802.field_8471),
    DEAD_BUSH(PlantTypeEnum.BUSH, class_1802.field_8689),
    CACTUS(PlantTypeEnum.BUSH, class_1802.field_17520),
    SUGAR_CANE(PlantTypeEnum.BUSH, class_1802.field_17531);

    private final PlantTypeEnum type;
    private final class_1792 item;
    private static final EnumMultiMap<PlantTypeEnum, PlantEnum> PLANTS_BY_TYPE;
    private static final Random RANDOM;

    private PlantEnum(PlantTypeEnum plantType, class_1792 plantItem) {
        this.type = plantType;
        this.item = plantItem;
    }

    public class_1792 getItem() {
        return this.item;
    }

    public static PlantEnum getRandom() {
        return PlantEnum.values()[RANDOM.nextInt(PlantEnum.values().length)];
    }

    public static boolean getRandomByType(String type, Out<PlantEnum> out) {
        if (type.equals("all")) {
            out.set(PlantEnum.getRandom());
            return true;
        }
        for (PlantTypeEnum plantType : PlantTypeEnum.values()) {
            if (!plantType.name().toLowerCase().equals(type)) continue;
            List<PlantEnum> plants = PLANTS_BY_TYPE.get(plantType);
            out.set(plants.get(RANDOM.nextInt(plants.size())));
            return true;
        }
        out.set(null);
        return false;
    }

    static {
        PLANTS_BY_TYPE = new EnumMultiMap(PlantTypeEnum.class);
        RANDOM = new Random();
        for (PlantEnum plant : PlantEnum.values()) {
            PLANTS_BY_TYPE.add(plant.type, plant);
        }
    }
}

