/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.wallpaper.utils;

import com.mojang.blaze3d.platform.IconSet;
import com.mojang.logging.LogUtils;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinGDI;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APIOptions;
import com.xkball.wallpaper.utils.ThrowableSupplier;
import com.xkball.wallpaper.utils.VanillaUtils;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.slf4j.Logger;

public class TheSystemTray {
    private static final Logger LOGGER = LogUtils.getLogger();
    private NOTIFYICONDATA nid = this.createNotifyIconData();
    public static final int NIM_ADD = 0;
    public static final int NIM_MODIFY = 1;
    public static final int NIM_DELETE = 2;
    public static final int NIF_MESSAGE = 1;
    public static final int NIF_ICON = 2;
    public static final int NIF_TIP = 4;

    public void closeTray() {
        User32.INSTANCE.DestroyIcon(this.nid.hIcon);
        User32.INSTANCE.DestroyWindow(this.nid.hWnd);
        Shell32.INSTANCE.Shell_NotifyIcon(2, this.nid);
    }

    public NOTIFYICONDATA createNotifyIconData() {
        String name = "MinePaper Engine";
        WinDef.HWND hwnd = TheSystemTray.createMessageWindow(name);
        WinDef.HICON hIcon = TheSystemTray.createIcon();
        NOTIFYICONDATA nid = new NOTIFYICONDATA();
        nid.cbSize = nid.size();
        nid.hWnd = hwnd;
        nid.uID = 1;
        nid.uFlags = 7;
        nid.uCallbackMessage = 1025;
        nid.hIcon = hIcon;
        System.arraycopy(name.toCharArray(), 0, nid.szTip, 0, name.length());
        boolean success = Shell32.INSTANCE.Shell_NotifyIcon(0, nid);
        return nid;
    }

    private static WinDef.HWND createMessageWindow(String className) {
        User32 user32 = User32.INSTANCE;
        WinUser.WNDCLASSEX wndclass = new WinUser.WNDCLASSEX();
        wndclass.lpszClassName = className;
        wndclass.lpfnWndProc = (hwnd, uMsg, wParam, lParam) -> {
            int event;
            if (uMsg > 1024 && ((event = lParam.intValue()) == 514 || event == 517)) {
                TheSystemTray.showContextMenu(hwnd);
            }
            return user32.DefWindowProc(hwnd, uMsg, wParam, lParam);
        };
        wndclass.hInstance = Kernel32.INSTANCE.GetModuleHandle(null);
        user32.RegisterClassEx(wndclass);
        return user32.CreateWindowEx(0, className, "HiddenTrayWindow", 0, 0, 0, 0, 0, null, null, wndclass.hInstance, null);
    }

    private static void showContextMenu(WinDef.HWND hwnd) {
        WinDef.HMENU hMenu = ExtendedUser32.INSTANCE.CreatePopupMenu();
        boolean success = ExtendedUser32.INSTANCE.AppendMenuW(hMenu, 0, new WinDef.WPARAM(1L), "Switch Foreground/Background");
        if (!success) {
            return;
        }
        WinDef.POINT pt = new WinDef.POINT();
        ExtendedUser32.INSTANCE.GetCursorPos(pt);
        ExtendedUser32.INSTANCE.SetForegroundWindow(hwnd);
        int cmd = ExtendedUser32.INSTANCE.TrackPopupMenu(hMenu, 288, pt.x, pt.y, 0, hwnd, null);
        if (cmd == 1) {
            VanillaUtils.ClientHandler.switchWindowState();
        }
    }

    private static WinDef.HICON createIcon() {
        IconSet iconSet = SharedConstants.getCurrentVersion().isStable() ? IconSet.RELEASE : IconSet.SNAPSHOT;
        List iconList = ThrowableSupplier.getOrThrow(() -> iconSet.getStandardIcons((PackResources)Minecraft.getInstance().getVanillaPackResources()));
        BufferedImage icon = ThrowableSupplier.getOrThrow(() -> ImageIO.read((InputStream)((IoSupplier)iconList.getLast()).get()));
        int width = icon.getWidth();
        int height = icon.getHeight();
        int[] pixels = new int[width * height];
        icon.getRGB(0, 0, width, height, pixels, 0, width);
        WinDef.HDC hdc = User32.INSTANCE.GetDC(null);
        WinGDI.BITMAPINFO bmi = new WinGDI.BITMAPINFO(3);
        bmi.bmiHeader.biSize = bmi.bmiHeader.size();
        bmi.bmiHeader.biWidth = width;
        bmi.bmiHeader.biHeight = -height;
        bmi.bmiHeader.biPlanes = 1;
        bmi.bmiHeader.biBitCount = (short)32;
        bmi.bmiHeader.biCompression = 3;
        bmi.bmiColors[0] = new WinGDI.RGBQUAD();
        bmi.bmiColors[0].rgbRed = (byte)-1;
        bmi.bmiColors[1] = new WinGDI.RGBQUAD();
        bmi.bmiColors[1].rgbGreen = (byte)-1;
        bmi.bmiColors[2] = new WinGDI.RGBQUAD();
        bmi.bmiColors[2].rgbBlue = (byte)-1;
        PointerByReference ppvBits = new PointerByReference();
        WinDef.HBITMAP colorBitmap = ExtendedGDI32.INSTANCE.CreateDIBSection(hdc, bmi, 0, ppvBits, null, 0);
        ppvBits.getValue().write(0L, pixels, 0, pixels.length);
        byte[] maskBits = new byte[width * height / 8];
        WinDef.HBITMAP maskBitmap = ExtendedGDI32.INSTANCE.CreateBitmap(width, height, 1, 1, maskBits);
        WinGDI.ICONINFO iconInfo = new WinGDI.ICONINFO();
        iconInfo.fIcon = true;
        iconInfo.hbmMask = maskBitmap;
        iconInfo.hbmColor = colorBitmap;
        WinDef.HICON hIcon = ExtendedUser32.INSTANCE.CreateIconIndirect(iconInfo);
        GDI32.INSTANCE.DeleteObject((WinNT.HANDLE)colorBitmap);
        GDI32.INSTANCE.DeleteObject((WinNT.HANDLE)maskBitmap);
        User32.INSTANCE.ReleaseDC(null, hdc);
        return hIcon;
    }

    public static class NOTIFYICONDATA
    extends Structure {
        public int cbSize;
        public WinDef.HWND hWnd;
        public int uID;
        public int uFlags;
        public int uCallbackMessage;
        public WinDef.HICON hIcon;
        public char[] szTip = new char[128];
        public int dwState;
        public int dwStateMask;
        public char[] szInfo = new char[256];
        public int uTimeoutOrVersion;
        public char[] szInfoTitle = new char[64];
        public int dwInfoFlags;
        public Guid.GUID guidItem;
        public WinDef.HICON hBalloonIcon;

        protected List<String> getFieldOrder() {
            return Arrays.asList("cbSize", "hWnd", "uID", "uFlags", "uCallbackMessage", "hIcon", "szTip", "dwState", "dwStateMask", "szInfo", "uTimeoutOrVersion", "szInfoTitle", "dwInfoFlags", "guidItem", "hBalloonIcon");
        }
    }

    public static interface Shell32
    extends Library {
        public static final Shell32 INSTANCE = (Shell32)Native.load((String)"shell32", Shell32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public boolean Shell_NotifyIcon(int var1, NOTIFYICONDATA var2);
    }

    public static interface ExtendedUser32
    extends User32 {
        public static final ExtendedUser32 INSTANCE = (ExtendedUser32)Native.load((String)"user32", ExtendedUser32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public WinDef.HICON CreateIconIndirect(WinGDI.ICONINFO var1);

        public WinDef.HMENU CreatePopupMenu();

        public boolean AppendMenuW(WinDef.HMENU var1, int var2, WinDef.WPARAM var3, String var4);

        public int TrackPopupMenu(WinDef.HMENU var1, int var2, int var3, int var4, int var5, WinDef.HWND var6, WinDef.RECT var7);
    }

    public static interface ExtendedGDI32
    extends GDI32 {
        public static final ExtendedGDI32 INSTANCE = (ExtendedGDI32)Native.load((String)"gdi32", ExtendedGDI32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public WinDef.HBITMAP CreateBitmap(int var1, int var2, int var3, int var4, byte[] var5);
    }
}

