/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.wallpaper.utils;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.xkball.wallpaper.MinePaperEngine;
import com.xkball.wallpaper.utils.WindowState;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL30;

public class VanillaUtils {

    public static class ClientHandler {
        private static boolean asBG = false;
        private static WindowState state;
        private static WinDef.HWND mcWindow;
        private static AtomicReference<WinDef.HWND> workerW;
        private static boolean pauseOnLoseFocusOld;

        public static void copyFrameBufferColorTo(RenderTarget from, int to) {
            GL30.glBindFramebuffer((int)36008, (int)from.frameBufferId);
            GL30.glBindFramebuffer((int)36009, (int)to);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)from.width, (int)from.height, (int)0, (int)0, (int)from.width, (int)from.height, (int)16384, (int)9728);
            GL30.glBindFramebuffer((int)36008, (int)0);
            GL30.glBindFramebuffer((int)36009, (int)0);
        }

        public static void setWindowAsBG(int w, int h) {
            if (workerW.get() != null) {
                User32.INSTANCE.DestroyWindow(workerW.get());
                workerW.set(null);
            }
            pauseOnLoseFocusOld = Minecraft.getInstance().options.pauseOnLostFocus;
            Minecraft.getInstance().options.pauseOnLostFocus = false;
            WinDef.HWND progman = User32.INSTANCE.FindWindow("Progman", null);
            User32.INSTANCE.SendMessageTimeout(progman, 1324, new WinDef.WPARAM(0L), new WinDef.LPARAM(0L), 0, 1000, null);
            User32.INSTANCE.EnumWindows((hwnd, data) -> {
                WinDef.HWND p = User32.INSTANCE.FindWindowEx(hwnd, null, "SHELLDLL_DefView", null);
                if (p != null) {
                    workerW.set(User32.INSTANCE.FindWindowEx(null, hwnd, "WorkerW", null));
                }
                return true;
            }, null);
            if (workerW.get() == null) {
                return;
            }
            User32.INSTANCE.ShowWindow(workerW.get(), 1);
            mcWindow = null;
            mcWindow = User32.INSTANCE.FindWindow(null, MinePaperEngine.currentWindowTitle);
            if (mcWindow == null) {
                return;
            }
            User32.INSTANCE.SetParent(mcWindow, workerW.get());
            int style = User32.INSTANCE.GetWindowLong(mcWindow, -16);
            style &= 0xFF30FFFF;
            User32.INSTANCE.SetWindowLong(mcWindow, -16, style |= 0x8000000);
            User32.INSTANCE.SetWindowPos(mcWindow, null, 0, 0, w, h, 84);
            User32.INSTANCE.SetFocus(null);
            Minecraft.getInstance().setScreen(null);
            asBG = true;
        }

        public static boolean isWindowAsBG() {
            return asBG;
        }

        public static void cancelWindowAsBG() {
            if (mcWindow == null) {
                return;
            }
            Minecraft.getInstance().options.pauseOnLostFocus = pauseOnLoseFocusOld;
            int style = User32.INSTANCE.GetWindowLong(mcWindow, -16);
            style |= 0xCF0000;
            User32.INSTANCE.SetWindowLong(mcWindow, -16, style &= 0xF7FFFFFF);
            User32.INSTANCE.SetWindowPos(mcWindow, null, 0, 0, 800, 600, 96);
            WinDef.HWND desktop = User32.INSTANCE.GetDesktopWindow();
            User32.INSTANCE.SetParent(mcWindow, desktop);
            if (workerW.get() != null) {
                User32.INSTANCE.ShowWindow(workerW.get(), 0);
                workerW.set(null);
            }
            User32.INSTANCE.RedrawWindow(null, null, null, new WinDef.DWORD(385L));
            asBG = false;
        }

        public static void switchWindowState() {
            if (state == null) {
                state = WindowState.current();
            }
            if (ClientHandler.isWindowAsBG()) {
                state.apply();
            } else {
                state = WindowState.current();
                WindowState.withASWallpaper().apply();
            }
        }

        static {
            workerW = new AtomicReference();
            pauseOnLoseFocusOld = false;
        }
    }
}

