/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.wallpaper.utils;

import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.platform.Window;
import com.xkball.wallpaper.utils.VanillaUtils;
import net.minecraft.client.Minecraft;
import org.lwjgl.glfw.GLFW;

public record WindowState(int x, int y, int width, int height, boolean asWallpaper, boolean fullscreen) {
    public void apply() {
        if (!this.asWallpaper) {
            VanillaUtils.ClientHandler.cancelWindowAsBG();
        }
        Window mcWindow = Minecraft.getInstance().getWindow();
        long window = mcWindow.getWindow();
        GLFW.glfwSetWindowPos((long)window, (int)this.x, (int)this.y);
        GLFW.glfwSetWindowSize((long)window, (int)this.width, (int)this.height);
        if (mcWindow.isFullscreen() != this.fullscreen) {
            mcWindow.toggleFullScreen();
            mcWindow.updateDisplay();
        }
        if (this.asWallpaper) {
            VanillaUtils.ClientHandler.setWindowAsBG(this.width, this.height);
        }
    }

    public static WindowState current() {
        Window mcWindow = Minecraft.getInstance().getWindow();
        return new WindowState(mcWindow.getX(), mcWindow.getY(), mcWindow.getWidth(), mcWindow.getHeight(), VanillaUtils.ClientHandler.isWindowAsBG(), mcWindow.isFullscreen());
    }

    public static WindowState withASWallpaper() {
        WindowState current = WindowState.current();
        ScreenManager screenManager = Minecraft.getInstance().virtualScreen.screenManager;
        Monitor monitor = screenManager.getMonitor(GLFW.glfwGetPrimaryMonitor());
        return new WindowState(WindowState.current().x(), WindowState.current().y(), monitor.getCurrentMode().getWidth(), monitor.getCurrentMode().getHeight(), true, false);
    }
}

