/*
 * Decompiled with CFR 0.152.
 */
package com.hidethemonkey.elfim;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ELConfig {
    private final FileConfiguration config;
    private final Logger logger;
    private String pluginName = "";
    private static boolean updateAvailable = false;
    public static final String REPLACE_ME = "replace-me";
    public static final String ENABLE_STATS = "enableStats";
    public static final String MCUserAvatarUrlKey = "MCUserAvatarUrl";
    public static final String MCUserBustUrlKey = "MCUserBustUrl";
    public static final String SLACK = "slack";
    public static final String DISCORD = "discord";

    public ELConfig(FileConfiguration fileConf, Logger log) {
        this.config = fileConf;
        this.logger = log;
        this.config.addDefault("slack.apiToken", (Object)REPLACE_ME);
        this.config.addDefault("slack.channelId", (Object)REPLACE_ME);
        this.config.addDefault(ENABLE_STATS, (Object)true);
        this.config.options().copyDefaults(true);
    }

    public String getGravatarEmail() {
        return this.config.getString("gravatarEmail");
    }

    public String getGravatarUrl() {
        return this.config.getString("gravatarUrl");
    }

    public Set<String> getKeys() {
        return this.config.getKeys(true);
    }

    public List<String> getLogProperties() {
        return this.config.getStringList("logServerProperties");
    }

    private void save() {
        String confPath = this.config.getCurrentPath() + "plugins/" + this.getPluginName() + "/config.yml";
        try {
            this.config.save(confPath);
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, "Could not save " + confPath, ioe);
        }
    }

    public void setBoolean(String key, Boolean value) {
        this.config.set(key, (Object)value);
        this.save();
    }

    public void setString(String key, String value) {
        this.config.set(key, (Object)(value != null ? value.trim() : null));
        this.save();
    }

    public boolean getLogBroadcasts(String service) {
        return this.config.getBoolean(service + ".events.logBroadcasts");
    }

    public boolean getLogChat(String service) {
        return this.config.getBoolean(service + ".events.logChat");
    }

    public boolean getLogPlayerAdvancement(String service) {
        return this.config.getBoolean(service + ".events.logPlayerAdvancement");
    }

    public boolean getLogPlayerCommands(String service) {
        return this.config.getBoolean(service + ".events.logPlayerCommands");
    }

    public boolean getLogPlayerDeath(String service) {
        return this.config.getBoolean(service + ".events.logPlayerDeath");
    }

    public boolean getLogPlayerJoinLeave(String service) {
        return this.config.getBoolean(service + ".events.logPlayerJoinLeave");
    }

    public boolean getLogPlayerRespawn(String service) {
        return this.config.getBoolean(service + ".events.logPlayerRespawn");
    }

    public boolean getLogPlayerTeleport(String service) {
        return this.config.getBoolean(service + ".events.logPlayerTeleport");
    }

    public boolean getLogUnsuccessfulLogin(String service) {
        return this.config.getBoolean(service + ".events.logUnsuccessfulLogin");
    }

    public boolean getLogStartupPlugins(String service) {
        return this.config.getBoolean(service + ".events.logStartupPlugins");
    }

    public boolean getLogServerCommand(String service) {
        return this.config.getBoolean(service + ".events.logServerCommand");
    }

    public boolean getLogServerStartStop(String service) {
        return this.config.getBoolean(service + ".events.logServerStartStop");
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String name) {
        this.pluginName = name;
    }

    public String getMCUserAvatarUrl(String uuid) {
        if (uuid == null) {
            uuid = "";
        }
        return this.config.getString(MCUserAvatarUrlKey) + uuid;
    }

    public String getMCUserBustUrl(String uuid) {
        if (uuid == null) {
            uuid = "";
        }
        return this.config.getString(MCUserBustUrlKey) + uuid;
    }

    public void log(String msg) {
        this.logger.info(msg);
    }

    public boolean getEnableStats() {
        return this.config.getBoolean(ENABLE_STATS);
    }

    public static void setUpdateAvailable(boolean updateAvailable) {
        ELConfig.updateAvailable = updateAvailable;
    }

    public static boolean getUpdateAvailable() {
        return updateAvailable;
    }

    public boolean getSlackEnabled() {
        return this.config.getBoolean("enableSlack");
    }

    public String getSlackAPIToken() {
        return this.config.getString("slack.apiToken");
    }

    public String getSlackChannelId() {
        return this.config.getString("slack.channelId");
    }

    public boolean getDiscordEnabled() {
        return this.config.getBoolean("enableDiscord");
    }

    public String getDiscordWebhookUrl() {
        return this.config.getString("discord.webhookUrl");
    }

    public String getDiscordBotName() {
        return this.config.getString("discord.botUserName");
    }

    public String getDiscordAvatarUrl() {
        return this.config.getString("discord.botAvatarUrl");
    }

    public int getDiscordColor(String name) {
        return this.config.getInt("discord.colors." + name);
    }

    public static void updateConfig(JavaPlugin plugin) {
        String currentVersion;
        File file = new File(plugin.getDataFolder(), "config.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration ymlConfig = YamlConfiguration.loadConfiguration((File)file);
        String configVersion = ymlConfig.getString("pluginVersion");
        if (configVersion == null || configVersion.isBlank()) {
            configVersion = "unknown";
        }
        if (!(currentVersion = plugin.getPluginMeta().getVersion()).equals(configVersion)) {
            File sourceFile = new File(plugin.getDataFolder(), file.getName());
            File destFile = new File(String.valueOf(plugin.getDataFolder()) + "/config." + configVersion + ".yml");
            plugin.getLogger().info("Found mismatched plugin version, updating config...");
            plugin.getLogger().info("old: " + configVersion + ", new: " + currentVersion);
            plugin.getLogger().info("Backing up config.yml to " + destFile.getName());
            if (sourceFile.renameTo(destFile)) {
                plugin.saveResource(file.getName(), true);
                try {
                    FileConfiguration fileConfig = plugin.getConfig();
                    fileConfig.load(file);
                    Set keys = ymlConfig.getKeys(true);
                    plugin.getLogger().info("Restoring previous configuration settings...");
                    for (String key : keys) {
                        Object oldValue = fileConfig.get(key);
                        Object newValue = ymlConfig.get(key);
                        if (key.equals("pluginVersion") || newValue instanceof MemorySection || newValue == null || newValue.equals(oldValue) || !fileConfig.contains(key)) continue;
                        plugin.getLogger().info("Updating " + key + " from " + String.valueOf(oldValue) + " to " + String.valueOf(newValue));
                        fileConfig.set(key, newValue);
                    }
                    fileConfig.save(file);
                    plugin.getLogger().info("Completed updating config.yml to latest version!");
                }
                catch (IOException | InvalidConfigurationException e) {
                    plugin.getLogger().log(Level.SEVERE, "Error processing updated config.yml", e);
                    plugin.saveResource(file.getName(), true);
                }
            } else {
                plugin.getLogger().warning("Failed to backup config.yml");
            }
        }
    }
}

