/*
 * Decompiled with CFR 0.152.
 */
package com.hidethemonkey.elfim;

import com.hidethemonkey.elfim.AdvancementConfig;
import com.hidethemonkey.elfim.ELConfig;
import com.hidethemonkey.elfim.bstats.bukkit.Metrics;
import com.hidethemonkey.elfim.bstats.charts.SimplePie;
import com.hidethemonkey.elfim.commands.CommandELFS;
import com.hidethemonkey.elfim.helpers.VersionChecker;
import com.hidethemonkey.elfim.helpers.VersionData;
import com.hidethemonkey.elfim.listeners.PlayerListeners;
import com.hidethemonkey.elfim.listeners.ServerListeners;
import com.hidethemonkey.elfim.messaging.DiscordPlayerHandler;
import com.hidethemonkey.elfim.messaging.DiscordServerHandler;
import com.hidethemonkey.elfim.messaging.PlayerHandlerInterface;
import com.hidethemonkey.elfim.messaging.ServerHandlerInterface;
import com.hidethemonkey.elfim.messaging.SlackPlayerHandler;
import com.hidethemonkey.elfim.messaging.SlackServerHandler;
import com.hidethemonkey.elfim.messaging.json.DiscordMessageFactory;
import java.util.Objects;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class ELFIM
extends JavaPlugin {
    private DiscordMessageFactory messageFactory;
    private Metrics metrics;
    private VersionData versionData;

    public void onLoad() {
        this.versionData = VersionChecker.getLatestReleaseVersion();
    }

    public void onEnable() {
        ELConfig.updateConfig(this);
        this.saveDefaultConfig();
        ELConfig elConfig = new ELConfig(this.getConfig(), this.getLogger());
        elConfig.setPluginName(this.getName());
        this.compareVersions();
        this.setupMetrics(elConfig);
        this.saveResource("advancements.yml", true);
        AdvancementConfig advConfig = new AdvancementConfig(this.getDataFolder());
        if (elConfig.getSlackEnabled()) {
            if (this.checkSlackToken(elConfig.getSlackAPIToken()) && this.checkSlackChannel(elConfig.getSlackChannelId())) {
                this.registerServerListeners("slack", elConfig, this.getServer().getPluginManager());
                this.registerPlayerListeners("slack", elConfig, advConfig, this.getServer().getPluginManager());
            } else {
                this.getLogger().warning("The Slack API token or channel is not configured!");
            }
        } else {
            this.getLogger().info("Slack integration is not enabled.");
        }
        if (elConfig.getDiscordEnabled()) {
            this.messageFactory = new DiscordMessageFactory(elConfig, this.getLogger());
            this.registerServerListeners("discord", elConfig, this.getServer().getPluginManager());
            this.registerPlayerListeners("discord", elConfig, advConfig, this.getServer().getPluginManager());
        } else {
            this.getLogger().info("Discord integration is not enabled.");
        }
        Objects.requireNonNull(this.getCommand("elfs")).setExecutor((CommandExecutor)new CommandELFS(elConfig));
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    private void setupMetrics(ELConfig config) {
        if (this.metrics == null) {
            if (config.getEnableStats()) {
                this.metrics = new Metrics((Plugin)this, 20980);
                this.metrics.addCustomChart(new SimplePie("system_language", () -> System.getProperty("user.language") + "_" + System.getProperty("user.country").toUpperCase()));
                this.metrics.addCustomChart(new SimplePie("enabled_platforms", () -> {
                    boolean slackEnabled = config.getSlackEnabled();
                    boolean discordEnabled = config.getDiscordEnabled();
                    if (slackEnabled && discordEnabled) {
                        return "Both";
                    }
                    if (slackEnabled) {
                        return "Slack";
                    }
                    if (discordEnabled) {
                        return "Discord";
                    }
                    return "None";
                }));
                this.metrics.addCustomChart(new SimplePie("log_server_props", () -> Integer.toString(config.getLogProperties().size())));
                this.metrics.addCustomChart(new SimplePie("log_gravatar_set", () -> {
                    String gravatarEmail = config.getGravatarEmail();
                    return Boolean.toString(!gravatarEmail.equals("replace-me") && !gravatarEmail.isEmpty());
                }));
                this.metrics.addCustomChart(new SimplePie("log_server_start_stop", () -> Boolean.toString(config.getLogServerStartStop("slack")) + ":" + Boolean.toString(config.getLogServerStartStop("discord"))));
                this.metrics.addCustomChart(new SimplePie("log_broadcasts", () -> Boolean.toString(config.getLogBroadcasts("slack")) + ":" + Boolean.toString(config.getLogBroadcasts("discord"))));
                this.metrics.addCustomChart(new SimplePie("log_server_command", () -> Boolean.toString(config.getLogServerCommand("slack")) + ":" + Boolean.toString(config.getLogServerCommand("discord"))));
                this.metrics.addCustomChart(new SimplePie("log_player_join_leave", () -> Boolean.toString(config.getLogPlayerJoinLeave("slack")) + ":" + Boolean.toString(config.getLogPlayerJoinLeave("discord"))));
                this.metrics.addCustomChart(new SimplePie("log_unsuccessful_login", () -> Boolean.toString(config.getLogUnsuccessfulLogin("slack")) + ":" + Boolean.toString(config.getLogUnsuccessfulLogin("discord"))));
                this.metrics.addCustomChart(new SimplePie("log_chat", () -> Boolean.toString(config.getLogChat("slack")) + ":" + Boolean.toString(config.getLogChat("discord"))));
                this.metrics.addCustomChart(new SimplePie("log_player_advancement", () -> Boolean.toString(config.getLogPlayerAdvancement("slack")) + ":" + Boolean.toString(config.getLogPlayerAdvancement("discord"))));
                this.metrics.addCustomChart(new SimplePie("log_player_commands", () -> Boolean.toString(config.getLogPlayerCommands("slack")) + ":" + Boolean.toString(config.getLogPlayerCommands("discord"))));
                this.metrics.addCustomChart(new SimplePie("log_player_death", () -> Boolean.toString(config.getLogPlayerDeath("slack")) + ":" + Boolean.toString(config.getLogPlayerDeath("discord"))));
                this.metrics.addCustomChart(new SimplePie("log_player_respawn", () -> Boolean.toString(config.getLogPlayerRespawn("slack")) + ":" + Boolean.toString(config.getLogPlayerRespawn("discord"))));
                this.metrics.addCustomChart(new SimplePie("log_player_teleport", () -> Boolean.toString(config.getLogPlayerTeleport("slack")) + ":" + Boolean.toString(config.getLogPlayerTeleport("discord"))));
            } else {
                this.getLogger().info("bStats is not enabled! Please consider activating this service to help me keep track of ELFIM usage. \ud83d\ude47");
            }
        }
    }

    private void registerServerListeners(String service, ELConfig config, PluginManager manager) {
        ServerHandlerInterface handler = this.getServerHandler(service);
        ServerListeners serverListeners = new ServerListeners(config, handler, (Plugin)this);
        if (config.getLogServerStartStop(service)) {
            manager.registerEvents((Listener)serverListeners.new ServerListeners.PluginEnableDisableListener(), (Plugin)this);
        }
        if (config.getLogBroadcasts(service)) {
            manager.registerEvents((Listener)serverListeners.new ServerListeners.BroadcastMessageListener(), (Plugin)this);
        }
        if (config.getLogServerCommand(service)) {
            manager.registerEvents((Listener)serverListeners.new ServerListeners.ServerCommandListener(), (Plugin)this);
        }
    }

    private void registerPlayerListeners(String service, ELConfig config, AdvancementConfig advConfig, PluginManager manager) {
        PlayerHandlerInterface handler = this.getPlayerHandler(service);
        PlayerListeners playerListeners = new PlayerListeners(config, advConfig, handler, (Plugin)this);
        if (config.getLogPlayerJoinLeave(service)) {
            manager.registerEvents((Listener)playerListeners.new PlayerListeners.PlayerJoinListener(), (Plugin)this);
            manager.registerEvents((Listener)playerListeners.new PlayerListeners.PlayerQuitListener(), (Plugin)this);
        }
        if (config.getLogUnsuccessfulLogin(service)) {
            manager.registerEvents((Listener)playerListeners.new PlayerListeners.PlayerLoginListener(), (Plugin)this);
        }
        if (config.getLogChat(service)) {
            manager.registerEvents((Listener)playerListeners.new PlayerListeners.AsyncPlayerChatListener(), (Plugin)this);
        }
        if (config.getLogPlayerAdvancement(service)) {
            manager.registerEvents((Listener)playerListeners.new PlayerListeners.PlayerAdvancementListener(), (Plugin)this);
        }
        if (config.getLogPlayerCommands(service)) {
            manager.registerEvents((Listener)playerListeners.new PlayerListeners.PlayerCommandListener(), (Plugin)this);
        }
        if (config.getLogPlayerDeath(service)) {
            manager.registerEvents((Listener)playerListeners.new PlayerListeners.PlayerDeathListener(), (Plugin)this);
        }
        if (config.getLogPlayerRespawn(service)) {
            manager.registerEvents((Listener)playerListeners.new PlayerListeners.PlayerRespawnListener(), (Plugin)this);
        }
        if (config.getLogPlayerTeleport(service)) {
            manager.registerEvents((Listener)playerListeners.new PlayerListeners.PlayerTeleportListener(), (Plugin)this);
        }
    }

    private boolean checkSlackChannel(String channelId) {
        if (channelId.isBlank() || channelId.equals("replace-me")) {
            this.getLogger().severe("The Slack channel must be set in /plugin/EventLoggerForIM/config.yml!");
            return false;
        }
        return true;
    }

    private boolean checkSlackToken(String token) {
        if (token.isBlank() || token.equals("replace-me")) {
            this.getLogger().severe("The Slack API token must be set in /plugin/EventLoggerForIM/config.yml!");
            return false;
        }
        return true;
    }

    private ServerHandlerInterface getServerHandler(String service) {
        if (service.equals("slack")) {
            return new SlackServerHandler();
        }
        if (service.equals("discord")) {
            return new DiscordServerHandler(this.messageFactory);
        }
        return null;
    }

    private PlayerHandlerInterface getPlayerHandler(String service) {
        if (service.equals("slack")) {
            return new SlackPlayerHandler();
        }
        if (service.equals("discord")) {
            return new DiscordPlayerHandler(this.messageFactory);
        }
        return null;
    }

    private void compareVersions() {
        DefaultArtifactVersion currentVersion;
        if (this.versionData == null) {
            this.getLogger().warning("Could not check for new versions. Please see https://hangar.papermc.io/HideTheMonkey/EventLoggerForIM for updates.");
            return;
        }
        DefaultArtifactVersion latestVersion = new DefaultArtifactVersion(this.versionData.getVersion());
        if (latestVersion.compareTo(currentVersion = new DefaultArtifactVersion(this.getPluginMeta().getVersion())) > 0) {
            ELConfig.setUpdateAvailable(true);
            this.getLogger().warning("****************************************************************************");
            this.getLogger().warning("* A new release of EventLoggerForIM is available!");
            this.getLogger().warning("*");
            this.getLogger().warning("* New version: " + this.versionData.getVersion());
            this.getLogger().warning("* Your version: " + this.getPluginMeta().getVersion());
            this.getLogger().warning("*");
            this.getLogger().warning("* Please update to take advantage of the latest features and bug fixes.");
            this.getLogger().warning("* Download here: https://hangar.papermc.io/HideTheMonkey/EventLoggerForIM");
            this.getLogger().warning("****************************************************************************");
        }
    }
}

