/*
 * Decompiled with CFR 0.152.
 */
package com.hidethemonkey.elfim.commands;

import com.hidethemonkey.elfim.ELConfig;
import java.util.Locale;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class CommandELFS
implements CommandExecutor {
    private ELConfig config;
    private Set<String> configKeys;
    private final String enableCMD = "enable";
    private final String disableCMD = "disable";
    private final String setCMD = "set";
    private final String tokenSubCMD = "token";
    private final String channelSubCMD = "channel";
    private final String saveMessage = "Setting updated, but will not become active until the server is restarted.";

    public CommandELFS(ELConfig config) {
        this.config = config;
        this.configKeys = config.getKeys();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args2) {
        String value;
        if (args2.length < 2) {
            return false;
        }
        String command = args2[0].toLowerCase(Locale.ROOT);
        String key = args2[1];
        String string = value = args2.length == 3 ? args2[2] : "";
        if (!sender.hasPermission("ELFIM.elfimadmin")) {
            sender.sendMessage((Component)Component.text("You do not have permission to run this command.", (TextColor)NamedTextColor.DARK_RED));
            return false;
        }
        if (command.isBlank() || !command.equals("enable") && !command.equals("disable") && !command.equals("set")) {
            sender.sendMessage((Component)Component.text("Command [" + command + "] must be either enable, disable, or set", (TextColor)NamedTextColor.DARK_RED));
            return false;
        }
        if (command.equals("enable") || command.equals("disable")) {
            if (this.configKeys.contains("slack.events." + key)) {
                this.config.setBoolean("slack.events." + key, command.equals("enable"));
                sender.sendMessage((Component)Component.text("Setting updated, but will not become active until the server is restarted.", (TextColor)NamedTextColor.GOLD));
            } else if (key.equals("slack") || key.equals("discord")) {
                this.config.setBoolean("enable" + key.substring(0, 1).toUpperCase(Locale.ROOT) + key.substring(1), command.equals("enable"));
                sender.sendMessage((Component)Component.text("Setting updated, but will not become active until the server is restarted.", (TextColor)NamedTextColor.GOLD));
            } else {
                sender.sendMessage((Component)Component.text("Unable to set value for [" + key + "]", (TextColor)NamedTextColor.DARK_RED));
                return false;
            }
        }
        if (command.equals("set")) {
            boolean validURLSubCommands;
            boolean validSlackSubCommands = key.equalsIgnoreCase("token") || key.equalsIgnoreCase("channel");
            boolean bl = validURLSubCommands = key.equalsIgnoreCase("MCUserAvatarUrl") || key.equalsIgnoreCase("MCUserBustUrl");
            if (validSlackSubCommands) {
                String slackKey = key.equalsIgnoreCase("token") ? "slack.apiToken" : "slack.channelId";
                this.config.setString(slackKey, value);
                sender.sendMessage((Component)Component.text("Setting updated, but will not become active until the server is restarted.", (TextColor)NamedTextColor.GOLD));
            } else if (validURLSubCommands) {
                this.config.setString(key, value);
                sender.sendMessage((Component)Component.text("Setting updated, but will not become active until the server is restarted.", (TextColor)NamedTextColor.GOLD));
            } else {
                sender.sendMessage((Component)Component.text("Sub Command [" + key + "] is not a valid option.", (TextColor)NamedTextColor.DARK_RED));
                return false;
            }
        }
        return true;
    }
}

