/*
 * Decompiled with CFR 0.152.
 */
package com.hidethemonkey.elfim.listeners;

import com.hidethemonkey.elfim.AdvancementConfig;
import com.hidethemonkey.elfim.ELConfig;
import com.hidethemonkey.elfim.messaging.PlayerHandlerInterface;
import io.papermc.paper.event.player.AsyncChatEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class PlayerListeners {
    private final ELConfig config;
    private final AdvancementConfig advConfig;
    private final PlayerHandlerInterface playerHandler;
    private final Plugin plugin;

    public PlayerListeners(ELConfig config, AdvancementConfig advConfig, PlayerHandlerInterface playerHandler, Plugin plugin) {
        this.config = config;
        this.advConfig = advConfig;
        this.playerHandler = playerHandler;
        this.plugin = plugin;
    }

    public class PlayerLoginListener
    implements Listener {
        @EventHandler
        public void onPlayerLogin(PlayerLoginEvent event) {
            if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
                PlayerListeners.this.playerHandler.playerFailedLogin(event, PlayerListeners.this.config, PlayerListeners.this.plugin.getLogger());
            }
        }
    }

    public class PlayerAdvancementListener
    implements Listener {
        @EventHandler
        public void onPlayerAdvancement(PlayerAdvancementDoneEvent event) {
            PlayerListeners.this.playerHandler.playerAdvancement(event, PlayerListeners.this.config, PlayerListeners.this.advConfig);
        }
    }

    public class PlayerQuitListener
    implements Listener {
        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            PlayerListeners.this.playerHandler.playerLeave(event.getPlayer(), PlayerListeners.this.config);
        }
    }

    public class PlayerJoinListener
    implements Listener {
        @EventHandler
        public void onPlayerJoin(PlayerJoinEvent event) {
            PlayerListeners.this.playerHandler.playerJoin(event.getPlayer(), PlayerListeners.this.config);
        }
    }

    public class PlayerTeleportListener
    implements Listener {
        @EventHandler
        public void onPlayerTeleport(PlayerTeleportEvent event) {
            PlayerListeners.this.playerHandler.playerTeleport(event, PlayerListeners.this.config);
        }
    }

    public class PlayerRespawnListener
    implements Listener {
        @EventHandler
        public void onPlayerRespawn(PlayerRespawnEvent event) {
            PlayerListeners.this.playerHandler.playerRespawn(event, PlayerListeners.this.config);
        }
    }

    public class PlayerDeathListener
    implements Listener {
        @EventHandler
        public void onPlayerDeath(PlayerDeathEvent event) {
            PlayerListeners.this.playerHandler.playerDeath(event, PlayerListeners.this.config);
        }
    }

    public class PlayerCommandListener
    implements Listener {
        @EventHandler
        public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
            PlayerListeners.this.playerHandler.playerCommand(event, PlayerListeners.this.config);
        }
    }

    public class AsyncPlayerChatListener
    implements Listener {
        @EventHandler
        public void onAsyncPlayerChat(AsyncChatEvent event) {
            PlayerListeners.this.playerHandler.playerChat(event, PlayerListeners.this.config);
        }
    }
}

