/*
 * Decompiled with CFR 0.152.
 */
package com.hidethemonkey.elfim.listeners;

import com.hidethemonkey.elfim.ELConfig;
import com.hidethemonkey.elfim.messaging.ServerHandlerInterface;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;

public class ServerListeners {
    private final ELConfig config;
    private ServerHandlerInterface serverHandler;
    private final Plugin plugin;

    public ServerListeners(ELConfig elConfig, ServerHandlerInterface handler, Plugin plugin) {
        this.config = elConfig;
        this.serverHandler = handler;
        this.plugin = plugin;
    }

    public class ServerCommandListener
    implements Listener {
        @EventHandler
        public void onServerCommand(ServerCommandEvent event) {
            ServerListeners.this.serverHandler.serverCommand(event, ServerListeners.this.config, ServerListeners.this.plugin.getLogger());
        }
    }

    public class BroadcastMessageListener
    implements Listener {
        @EventHandler
        public void onBroadcastMessage(BroadcastMessageEvent event) {
            ServerListeners.this.serverHandler.broadcastChat(event, ServerListeners.this.config, ServerListeners.this.plugin.getLogger());
        }
    }

    public class PluginEnableDisableListener
    implements Listener {
        @EventHandler
        public void onPluginEnable(PluginEnableEvent event) {
            if (event.getPlugin().getName().equals(ServerListeners.this.plugin.getName())) {
                ServerListeners.this.serverHandler.startup(event.getPlugin().getServer(), ServerListeners.this.config, ServerListeners.this.config.getLogStartupPlugins(ServerListeners.this.serverHandler.getServiceName()));
            }
        }

        @EventHandler
        public void onPluginDisable(PluginDisableEvent event) {
            if (event.getPlugin().getName().equals(ServerListeners.this.plugin.getName())) {
                ServerListeners.this.serverHandler.shutdown(event.getPlugin().getServer(), ServerListeners.this.config);
            }
        }
    }
}

