/*
 * Decompiled with CFR 0.152.
 */
package com.hidethemonkey.elfim.messaging;

import com.slack.api.model.block.ContextBlock;
import com.slack.api.model.block.ContextBlockElement;
import com.slack.api.model.block.HeaderBlock;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.model.block.SectionBlock;
import com.slack.api.model.block.composition.BlockCompositions;
import com.slack.api.model.block.composition.MarkdownTextObject;
import com.slack.api.model.block.composition.TextObject;
import com.slack.api.model.block.element.ImageElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BlockBuilder {
    public static HeaderBlock getHeader(String text) {
        return HeaderBlock.builder().text(BlockCompositions.plainText(text)).build();
    }

    public static MarkdownTextObject getMarkdown(String text) {
        return MarkdownTextObject.builder().text(text).build();
    }

    public static ImageElement getImageElement(String url, String alt) {
        return ImageElement.builder().imageUrl(url).altText(alt).build();
    }

    public static ContextBlock getContextBlock(ContextBlockElement ... elements) {
        return ContextBlock.builder().elements(Arrays.asList(elements)).build();
    }

    public static ContextBlock getContextBlock(List<ContextBlockElement> elements) {
        return ContextBlock.builder().elements(elements).build();
    }

    public static SectionBlock getSection(String text, ImageElement image) {
        return SectionBlock.builder().text(BlockCompositions.markdownText(text)).accessory(image).build();
    }

    public static SectionBlock getSectionWithFields(ImageElement image, TextObject ... text) {
        return SectionBlock.builder().fields(Arrays.asList(text)).accessory(image).build();
    }

    public static List<LayoutBlock> getListBlocksWithHeader(String headerText) {
        ArrayList<LayoutBlock> blocks = new ArrayList<LayoutBlock>();
        blocks.add(BlockBuilder.getHeader(headerText));
        return blocks;
    }
}

