/*
 * Decompiled with CFR 0.152.
 */
package com.hidethemonkey.elfim.messaging;

import com.google.gson.Gson;
import com.hidethemonkey.elfim.AdvancementConfig;
import com.hidethemonkey.elfim.ELConfig;
import com.hidethemonkey.elfim.ELFIM;
import com.hidethemonkey.elfim.bstats.charts.SimplePie;
import com.hidethemonkey.elfim.helpers.StringUtils;
import com.hidethemonkey.elfim.messaging.MessageHandler;
import com.hidethemonkey.elfim.messaging.PlayerHandlerInterface;
import com.hidethemonkey.elfim.messaging.json.DiscordMessage;
import com.hidethemonkey.elfim.messaging.json.DiscordMessageFactory;
import com.hidethemonkey.elfim.messaging.json.Embed;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.logging.Logger;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class DiscordPlayerHandler
extends MessageHandler
implements PlayerHandlerInterface {
    private final Gson gson = new Gson();
    private DiscordMessageFactory messageFactory;

    public DiscordPlayerHandler(DiscordMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public String getServiceName() {
        return "discord";
    }

    @Override
    public void playerFailedLogin(PlayerLoginEvent event, ELConfig config, Logger logger) {
        Embed embed = new Embed(config.getDiscordColor("playerFailedLogin"));
        embed.setTitle("Tried to Log in");
        embed.addAuthor(event.getPlayer().getName(), config.getMCUserAvatarUrl(event.getPlayer().getUniqueId().toString()));
        embed.setDescription(((TextComponent)event.kickMessage()).content());
        DiscordMessage message = this.messageFactory.getMessage(embed);
        this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), logger);
    }

    @Override
    public void playerJoin(Player player, ELConfig config) {
        Embed embed = new Embed(config.getDiscordColor("playerJoin"));
        embed.setTitle("Joined Server");
        embed.addAuthor(player.getName(), config.getMCUserAvatarUrl(player.getUniqueId().toString()));
        embed.addField("NAME", player.getName());
        embed.addField("OP", Boolean.toString(player.isOp()));
        embed.addField("LEVEL", Integer.toString(player.getLevel()));
        embed.addField("ADDRESS", player.getAddress().getHostName());
        embed.addField("EXP", Integer.toString(player.getTotalExperience()));
        embed.addField("XYZ", StringUtils.getLocationString(player.getLocation()));
        embed.addField("ONLINE PLAYERS", Integer.toString(player.getServer().getOnlinePlayers().size()));
        embed.addField("WORLD", player.getWorld().getName());
        embed.addField("GAME MODE", player.getGameMode().toString());
        embed.setImage(config.getMCUserBustUrl(player.getUniqueId().toString()));
        DiscordMessage message = this.messageFactory.getMessage(embed);
        Logger logger = player.getServer().getPluginManager().getPlugin(config.getPluginName()).getLogger();
        this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), logger);
        ELFIM plugin = (ELFIM)player.getServer().getPluginManager().getPlugin(config.getPluginName());
        plugin.getMetrics().addCustomChart(new SimplePie("player_locale", () -> String.valueOf(player.locale())));
    }

    @Override
    public void playerLeave(Player player, ELConfig config) {
        long count = player.getServer().getOnlinePlayers().size() - 1;
        String content = "Online count: **" + count + "/" + player.getServer().getMaxPlayers() + "**";
        Embed embed = new Embed(config.getDiscordColor("playerLeave"));
        embed.setTitle("Left Server");
        embed.addAuthor(player.getName(), config.getMCUserAvatarUrl(player.getUniqueId().toString()));
        embed.setDescription(content);
        DiscordMessage message = this.messageFactory.getMessage(embed);
        Logger logger = player.getServer().getPluginManager().getPlugin(config.getPluginName()).getLogger();
        this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), logger);
    }

    @Override
    public void playerChat(AsyncChatEvent event, ELConfig config) {
        Player player = event.getPlayer();
        Embed embed = new Embed(config.getDiscordColor("playerChat"));
        embed.setTitle("Said in Chat");
        embed.addAuthor(player.getName(), config.getMCUserAvatarUrl(player.getUniqueId().toString()));
        embed.setDescription(((TextComponent)event.message()).content());
        DiscordMessage message = this.messageFactory.getMessage(embed);
        Logger logger = player.getServer().getPluginManager().getPlugin(config.getPluginName()).getLogger();
        this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), logger);
    }

    @Override
    public void playerCommand(PlayerCommandPreprocessEvent event, ELConfig config) {
        Player player = event.getPlayer();
        Embed embed = new Embed(config.getDiscordColor("playerCommand"));
        embed.setTitle("Issued Command");
        embed.addAuthor(player.getName(), config.getMCUserAvatarUrl(player.getUniqueId().toString()));
        embed.setDescription("`" + event.getMessage() + "`");
        DiscordMessage message = this.messageFactory.getMessage(embed);
        Logger logger = player.getServer().getPluginManager().getPlugin(config.getPluginName()).getLogger();
        this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), logger);
    }

    @Override
    public void playerAdvancement(PlayerAdvancementDoneEvent event, ELConfig config, AdvancementConfig advConfig) {
        if (!event.getAdvancement().getKey().getKey().startsWith("recipes")) {
            Player player = event.getPlayer();
            Embed embed = new Embed(config.getDiscordColor("playerAdvancement"));
            embed.setTitle("Made Advancement");
            embed.addAuthor(player.getName(), config.getMCUserAvatarUrl(player.getUniqueId().toString()));
            embed.setDescription("`" + advConfig.getAdvancementTitle(event.getAdvancement().getKey().getKey().toString()) + "`");
            DiscordMessage message = this.messageFactory.getMessage(embed);
            Logger logger = player.getServer().getPluginManager().getPlugin(config.getPluginName()).getLogger();
            this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), logger);
        }
    }

    @Override
    public void playerDeath(PlayerDeathEvent event, ELConfig config) {
        Player player = event.getEntity();
        Embed embed = new Embed(config.getDiscordColor("playerDeath"));
        embed.setTitle("Died");
        embed.addAuthor(player.getName(), config.getMCUserAvatarUrl(player.getUniqueId().toString()));
        String deathMessage = (String)LegacyComponentSerializer.legacySection().serializeOrNull(event.deathMessage());
        embed.setDescription(deathMessage);
        DiscordMessage message = this.messageFactory.getMessage(embed);
        Logger logger = player.getServer().getPluginManager().getPlugin(config.getPluginName()).getLogger();
        this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), logger);
    }

    @Override
    public void playerRespawn(PlayerRespawnEvent event, ELConfig config) {
        Player player = event.getPlayer();
        PlayerRespawnEvent.RespawnReason reason = event.getRespawnReason();
        Embed embed = new Embed(config.getDiscordColor("playerRespawn"));
        embed.setTitle("Respawned");
        embed.addAuthor(player.getName(), config.getMCUserAvatarUrl(player.getUniqueId().toString()));
        embed.setDescription(player.getName() + " respawned due to " + reason.toString() + ".");
        DiscordMessage message = this.messageFactory.getMessage(embed);
        Logger logger = player.getServer().getPluginManager().getPlugin(config.getPluginName()).getLogger();
        this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), logger);
    }

    @Override
    public void playerTeleport(PlayerTeleportEvent event, ELConfig config) {
        String toLoc;
        String fromLoc = StringUtils.getLocationString(event.getFrom());
        if (fromLoc.equals(toLoc = StringUtils.getLocationString(event.getTo())) || event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Embed embed = new Embed(config.getDiscordColor("playerTeleport"));
        embed.setTitle("Teleported");
        embed.addAuthor(player.getName(), config.getMCUserAvatarUrl(player.getUniqueId().toString()));
        embed.setDescription("From: **" + fromLoc + "** To: **" + toLoc + "** \nReason: **" + event.getCause().toString() + "**");
        DiscordMessage message = this.messageFactory.getMessage(embed);
        Logger logger = player.getServer().getPluginManager().getPlugin(config.getPluginName()).getLogger();
        this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), logger);
    }
}

