/*
 * Decompiled with CFR 0.152.
 */
package com.hidethemonkey.elfim.messaging;

import com.google.gson.Gson;
import com.hidethemonkey.elfim.ELConfig;
import com.hidethemonkey.elfim.helpers.NetworkUtils;
import com.hidethemonkey.elfim.helpers.StringUtils;
import com.hidethemonkey.elfim.messaging.MessageHandler;
import com.hidethemonkey.elfim.messaging.ServerHandlerInterface;
import com.hidethemonkey.elfim.messaging.json.DiscordMessage;
import com.hidethemonkey.elfim.messaging.json.DiscordMessageFactory;
import com.hidethemonkey.elfim.messaging.json.Embed;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Server;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;

public class DiscordServerHandler
extends MessageHandler
implements ServerHandlerInterface {
    private final Gson gson = new Gson();
    private DiscordMessageFactory messageFactory;

    public DiscordServerHandler(DiscordMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public String getServiceName() {
        return "discord";
    }

    @Override
    public void startup(Server server, ELConfig config, boolean logPlugins) {
        List<String> logProperties;
        Plugin plugin = server.getPluginManager().getPlugin(config.getPluginName());
        String pluginVersion = plugin.getPluginMeta().getVersion();
        String updateAvailable = ELConfig.getUpdateAvailable() ? " ([update available](https://github.com/HideTheMonkey/EventLoggerForIM/releases/latest))" : "";
        Embed embed = new Embed(config.getDiscordColor("serverStartup"));
        embed.setTitle("**Server Started**");
        embed.addField("MOTD", ((TextComponent)server.motd()).content());
        embed.addField("TYPE", server.getName());
        embed.addField("VERSION", server.getVersion());
        embed.addField("MAX PLAYERS", Integer.toString(server.getMaxPlayers()));
        embed.addField("GAME MODE", server.getDefaultGameMode().toString());
        embed.addField("LOCAL IP", NetworkUtils.getLocalIP(server.getIp()));
        embed.addField("EXTERNAL IP", NetworkUtils.getExternalIP());
        embed.addField("ELFIM VERSION", pluginVersion + updateAvailable);
        DiscordMessage message = this.messageFactory.getMessage(embed);
        if (logPlugins) {
            Plugin[] plugins;
            Embed pluginEmbed = new Embed(config.getDiscordColor("serverPlugins"));
            pluginEmbed.setTitle("**Installed Plugins**");
            for (Plugin installedPlugin : plugins = server.getPluginManager().getPlugins()) {
                pluginEmbed.addField(installedPlugin.getName(), installedPlugin.getPluginMeta().getVersion());
            }
            message.addEmbed(pluginEmbed);
        }
        if ((logProperties = config.getLogProperties()).size() > 0) {
            Embed propertiesEmbed = new Embed(config.getDiscordColor("serverProperties"));
            propertiesEmbed.setTitle("**Server Properties**");
            Properties props = new Properties();
            try {
                props.load(new FileInputStream("server.properties"));
                for (String key : logProperties) {
                    String value = props.getProperty(key);
                    if (value == null) {
                        value = "";
                    }
                    propertiesEmbed.addField(key, value);
                }
            }
            catch (Exception e) {
                propertiesEmbed.addField("Error", e.getLocalizedMessage());
                e.printStackTrace();
            }
            message.addEmbed(propertiesEmbed);
        }
        this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), plugin.getLogger());
    }

    @Override
    public void shutdown(Server server, ELConfig config) {
        Plugin plugin = server.getPluginManager().getPlugin(config.getPluginName());
        String pluginVersion = plugin.getPluginMeta().getVersion();
        String updateAvailable = ELConfig.getUpdateAvailable() ? " ([update available](https://github.com/HideTheMonkey/EventLoggerForIM/releases/latest))" : "";
        Embed embed = new Embed(config.getDiscordColor("serverShutdown"));
        embed.setTitle("**Server Stopping**");
        embed.addField("MOTD", ((TextComponent)server.motd()).content());
        embed.addField("TYPE", server.getName());
        embed.addField("VERSION", server.getVersion());
        embed.addField("ONLINE PLAYERS", Integer.toString(server.getOnlinePlayers().size()));
        embed.addField("GAME MODE", server.getDefaultGameMode().toString());
        embed.addField("ELFIM VERSION", pluginVersion + updateAvailable);
        DiscordMessage message = this.messageFactory.getMessage(embed);
        this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), plugin.getLogger());
    }

    @Override
    public void serverCommand(ServerCommandEvent event, ELConfig config, Logger logger) {
        Embed embed = new Embed(config.getDiscordColor("serverCommand"));
        embed.setTitle("Server Command");
        embed.setDescription("*" + event.getSender().getName() + "* issued command: `" + event.getCommand() + "`");
        DiscordMessage message = this.messageFactory.getMessage(embed);
        this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), logger);
    }

    @Override
    public void broadcastChat(BroadcastMessageEvent event, ELConfig config, Logger logger) {
        Embed embed = new Embed(config.getDiscordColor("serverBroadcast"));
        embed.setTitle("Broadcast Message");
        embed.setDescription(StringUtils.removeSpecialChars(((TextComponent)event.message()).content()));
        DiscordMessage message = this.messageFactory.getMessage(embed);
        this.postWebhook(config.getDiscordWebhookUrl(), this.gson.toJson(message), logger);
    }
}

