/*
 * Decompiled with CFR 0.152.
 */
package com.hidethemonkey.elfim.messaging;

import com.slack.api.Slack;
import com.slack.api.SlackConfig;
import com.slack.api.model.block.LayoutBlock;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class MessageHandler {
    private final Slack slack = Slack.getInstance(new SlackConfig());
    private final MediaType JSON = MediaType.get("application/json; charset=utf-8");
    private final OkHttpClient client = new OkHttpClient();

    protected String postWebhook(String url, String json, Logger logger) {
        RequestBody body = RequestBody.create(json, this.JSON);
        Request request = new Request.Builder().url(url).post(body).build();
        String responseBody = "";
        try (Response response = this.client.newCall(request).execute();){
            responseBody = response.body().string();
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Error in MessageHandler.postWebhook()", ioe);
        }
        return responseBody;
    }

    protected void postBlocks(List<LayoutBlock> blocks, String message, String channel, String token) {
        this.slack.methodsAsync(token).chatPostMessage(r -> r.channel(channel).blocks(blocks).text(message));
    }

    protected void postMessage(String message, String channel, String token) {
        this.slack.methodsAsync(token).chatPostMessage(r -> r.channel(channel).text(message));
    }
}

