/*
 * Decompiled with CFR 0.152.
 */
package com.hidethemonkey.elfim.messaging;

import com.hidethemonkey.elfim.AdvancementConfig;
import com.hidethemonkey.elfim.ELConfig;
import com.hidethemonkey.elfim.ELFIM;
import com.hidethemonkey.elfim.bstats.charts.SimplePie;
import com.hidethemonkey.elfim.helpers.StringUtils;
import com.hidethemonkey.elfim.messaging.BlockBuilder;
import com.hidethemonkey.elfim.messaging.MessageHandler;
import com.hidethemonkey.elfim.messaging.PlayerHandlerInterface;
import com.slack.api.model.block.LayoutBlock;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class SlackPlayerHandler
extends MessageHandler
implements PlayerHandlerInterface {
    @Override
    public String getServiceName() {
        return "slack";
    }

    @Override
    public void playerFailedLogin(PlayerLoginEvent event, ELConfig config, Logger logger) {
        String message = "*" + event.getPlayer().getName() + "* attempted to log in.\n" + ((TextComponent)event.kickMessage()).content();
        this.postMessage(message, config.getSlackChannelId(), config.getSlackAPIToken());
    }

    @Override
    public void playerJoin(Player player, ELConfig config) {
        List<LayoutBlock> blocks = BlockBuilder.getListBlocksWithHeader("Player Joined");
        blocks.add(BlockBuilder.getSectionWithFields(BlockBuilder.getImageElement(config.getMCUserBustUrl(player.getUniqueId().toString()), player.getName()), BlockBuilder.getMarkdown("*NAME:* " + player.getName()), BlockBuilder.getMarkdown("*ADDRESS:* " + player.getAddress().getHostName()), BlockBuilder.getMarkdown("*OP:* " + player.isOp()), BlockBuilder.getMarkdown("*ONLINE PLAYERS:* " + player.getServer().getOnlinePlayers().size()), BlockBuilder.getMarkdown("*EXP:* " + player.getTotalExperience()), BlockBuilder.getMarkdown("*LEVEL:* " + player.getLevel()), BlockBuilder.getMarkdown("*WORLD:* " + player.getWorld().getName()), BlockBuilder.getMarkdown("*XYZ:* " + StringUtils.getLocationString(player.getLocation())), BlockBuilder.getMarkdown("*GAME MODE:* " + player.getGameMode().toString())));
        String message = player.getName() + " joined the server.";
        this.postBlocks(blocks, message, config.getSlackChannelId(), config.getSlackAPIToken());
        ELFIM plugin = (ELFIM)player.getServer().getPluginManager().getPlugin(config.getPluginName());
        plugin.getMetrics().addCustomChart(new SimplePie("player_locale", () -> player.locale().toString()));
    }

    @Override
    public void playerLeave(Player player, ELConfig config) {
        long count = player.getServer().getOnlinePlayers().size() - 1;
        String message = "*" + player.getName() + "* left the server! Online count: *" + count + "/" + player.getServer().getMaxPlayers() + "*";
        List<LayoutBlock> blocks = BlockBuilder.getListBlocksWithHeader("Player Left");
        blocks.add(BlockBuilder.getContextBlock(BlockBuilder.getImageElement(config.getMCUserAvatarUrl(player.getUniqueId().toString()), player.getName()), BlockBuilder.getMarkdown(message)));
        this.postBlocks(blocks, message, config.getSlackChannelId(), config.getSlackAPIToken());
    }

    @Override
    public void playerChat(AsyncChatEvent event, ELConfig config) {
        Player player = event.getPlayer();
        String message = "*" + player.getName() + "* said: " + ((TextComponent)event.message()).content();
        ArrayList<LayoutBlock> blocks = new ArrayList<LayoutBlock>();
        blocks.add(BlockBuilder.getContextBlock(BlockBuilder.getImageElement(config.getMCUserAvatarUrl(player.getUniqueId().toString()), player.getName()), BlockBuilder.getMarkdown(message)));
        this.postBlocks(blocks, message, config.getSlackChannelId(), config.getSlackAPIToken());
    }

    @Override
    public void playerCommand(PlayerCommandPreprocessEvent event, ELConfig config) {
        String message = "*" + event.getPlayer().getName() + "* issued command: `" + event.getMessage() + "`";
        this.postMessage(message, config.getSlackChannelId(), config.getSlackAPIToken());
    }

    @Override
    public void playerAdvancement(PlayerAdvancementDoneEvent event, ELConfig config, AdvancementConfig advConfig) {
        if (!event.getAdvancement().getKey().getKey().startsWith("recipes")) {
            String message = "*" + event.getPlayer().getName() + "* has made the advancement `" + advConfig.getAdvancementTitle(event.getAdvancement().getKey().getKey().toString()) + "`";
            this.postMessage(message, config.getSlackChannelId(), config.getSlackAPIToken());
        }
    }

    @Override
    public void playerDeath(PlayerDeathEvent event, ELConfig config) {
        List<LayoutBlock> blocks = BlockBuilder.getListBlocksWithHeader("Player Died");
        Player player = event.getEntity();
        String deathMessage = (String)LegacyComponentSerializer.legacySection().serializeOrNull(event.deathMessage());
        blocks.add(BlockBuilder.getContextBlock(BlockBuilder.getImageElement(config.getMCUserAvatarUrl(player.getUniqueId().toString()), player.getName()), BlockBuilder.getMarkdown(deathMessage)));
        this.postBlocks(blocks, deathMessage, config.getSlackChannelId(), config.getSlackAPIToken());
    }

    @Override
    public void playerRespawn(PlayerRespawnEvent event, ELConfig config) {
        List<LayoutBlock> blocks = BlockBuilder.getListBlocksWithHeader("Player Respawned");
        Player player = event.getPlayer();
        PlayerRespawnEvent.RespawnReason reason = event.getRespawnReason();
        blocks.add(BlockBuilder.getContextBlock(BlockBuilder.getImageElement(config.getMCUserAvatarUrl(player.getUniqueId().toString()), player.getName()), BlockBuilder.getMarkdown(player.getName() + " respawned due to " + reason.toString() + ".")));
        this.postBlocks(blocks, player.getName() + " respawned.", config.getSlackChannelId(), config.getSlackAPIToken());
    }

    @Override
    public void playerTeleport(PlayerTeleportEvent event, ELConfig config) {
        String toLoc;
        String fromLoc = StringUtils.getLocationString(event.getFrom());
        if (fromLoc.equals(toLoc = StringUtils.getLocationString(event.getTo())) || event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        String message = "*" + player.getName() + "* teleported from *" + fromLoc + "* to *" + toLoc + "* \nReason: *" + event.getCause().toString() + "*";
        this.postMessage(message, config.getSlackChannelId(), config.getSlackAPIToken());
    }
}

