/*
 * Decompiled with CFR 0.152.
 */
package com.hidethemonkey.elfim.messaging;

import com.hidethemonkey.elfim.ELConfig;
import com.hidethemonkey.elfim.helpers.NetworkUtils;
import com.hidethemonkey.elfim.helpers.StringUtils;
import com.hidethemonkey.elfim.messaging.BlockBuilder;
import com.hidethemonkey.elfim.messaging.MessageHandler;
import com.hidethemonkey.elfim.messaging.ServerHandlerInterface;
import com.slack.api.model.block.ContextBlockElement;
import com.slack.api.model.block.LayoutBlock;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Server;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class SlackServerHandler
extends MessageHandler
implements ServerHandlerInterface {
    @Override
    public String getServiceName() {
        return "slack";
    }

    @Override
    public void startup(Server server, ELConfig config, boolean logPlugins) {
        List<String> logProperties;
        List<LayoutBlock> blocks = BlockBuilder.getListBlocksWithHeader("Server Started");
        String pluginVersion = server.getPluginManager().getPlugin(config.getPluginName()).getPluginMeta().getVersion();
        String updateAvailable = ELConfig.getUpdateAvailable() ? " (<https://github.com/HideTheMonkey/EventLoggerForIM/releases/latest|update available>)" : "";
        blocks.add(BlockBuilder.getContextBlock(BlockBuilder.getMarkdown("*MOTD:* " + ((TextComponent)server.motd()).content()), BlockBuilder.getMarkdown("*TYPE:* " + server.getName()), BlockBuilder.getMarkdown("*VERSION:* " + server.getVersion()), BlockBuilder.getMarkdown("*MAX PLAYERS:* " + server.getMaxPlayers()), BlockBuilder.getMarkdown("*GAME MODE:* " + String.valueOf(server.getDefaultGameMode())), BlockBuilder.getMarkdown("*LOCAL IP:* " + NetworkUtils.getLocalIP(server.getIp())), BlockBuilder.getMarkdown("*EXTERNAL IP:* " + NetworkUtils.getExternalIP()), BlockBuilder.getMarkdown("*ELFIM VERSION:* " + pluginVersion + updateAvailable)));
        String serverName = ((TextComponent)server.motd()).content().isBlank() ? server.getName() : ((TextComponent)server.motd()).content();
        String message = "Minecraft server `" + serverName + "` is now online.";
        this.postBlocks(blocks, message, config.getSlackChannelId(), config.getSlackAPIToken());
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (logPlugins) {
            this.listPlugins(server.getPluginManager(), config);
        }
        if ((logProperties = config.getLogProperties()).size() > 0) {
            this.listPproperties(server.getPluginManager(), config, logProperties);
        }
    }

    @Override
    public void shutdown(Server server, ELConfig config) {
        List<LayoutBlock> blocks = BlockBuilder.getListBlocksWithHeader("Server Stopping");
        String pluginVersion = server.getPluginManager().getPlugin(config.getPluginName()).getPluginMeta().getVersion();
        String updateAvailable = ELConfig.getUpdateAvailable() ? " (<https://github.com/HideTheMonkey/EventLoggerForIM/releases/latest|update available>)" : "";
        blocks.add(BlockBuilder.getContextBlock(BlockBuilder.getMarkdown("*MOTD:* " + ((TextComponent)server.motd()).content()), BlockBuilder.getMarkdown("*TYPE:* " + server.getName()), BlockBuilder.getMarkdown("*VERSION:* " + server.getVersion()), BlockBuilder.getMarkdown("*ONLINE PLAYERS:* " + server.getOnlinePlayers().size()), BlockBuilder.getMarkdown("*GAME MODE:* " + String.valueOf(server.getDefaultGameMode())), BlockBuilder.getMarkdown("*ELFIM VERSION:* " + pluginVersion + updateAvailable)));
        String serverName = ((TextComponent)server.motd()).content().isBlank() ? server.getName() : ((TextComponent)server.motd()).content();
        String message = "`" + serverName + "` is shutting down! Players still online: *" + server.getOnlinePlayers().size() + "*";
        this.postBlocks(blocks, message, config.getSlackChannelId(), config.getSlackAPIToken());
    }

    private void listPlugins(PluginManager manager, ELConfig config) {
        Plugin[] plugins = manager.getPlugins();
        List<LayoutBlock> blocks = BlockBuilder.getListBlocksWithHeader("Installed Plugins");
        ArrayList<ContextBlockElement> list = new ArrayList<ContextBlockElement>();
        for (Plugin plugin : plugins) {
            list.add(BlockBuilder.getMarkdown("*" + plugin.getName() + ":* " + plugin.getPluginMeta().getVersion()));
        }
        blocks.add(BlockBuilder.getContextBlock(list));
        this.postBlocks(blocks, "List of plugins", config.getSlackChannelId(), config.getSlackAPIToken());
    }

    private void listPproperties(PluginManager manager, ELConfig config, List<String> properties) {
        Properties props = new Properties();
        ArrayList<ContextBlockElement> list = new ArrayList<ContextBlockElement>();
        List<LayoutBlock> blocks = BlockBuilder.getListBlocksWithHeader("Server Properties");
        try {
            props.load(new FileInputStream("server.properties"));
            for (String key : properties) {
                list.add(BlockBuilder.getMarkdown("*" + key + ":* " + props.getProperty(key)));
            }
        }
        catch (Exception e) {
            list.add(BlockBuilder.getMarkdown("Error loading server.properties: " + e.getLocalizedMessage()));
            e.printStackTrace();
        }
        blocks.add(BlockBuilder.getContextBlock(list));
        this.postBlocks(blocks, "List of properties", config.getSlackChannelId(), config.getSlackAPIToken());
    }

    @Override
    public void serverCommand(ServerCommandEvent event, ELConfig config, Logger logger) {
        String message = "*" + event.getSender().getName() + "* issued server command: `" + event.getCommand() + "`";
        this.postMessage(message, config.getSlackChannelId(), config.getSlackAPIToken());
    }

    @Override
    public void broadcastChat(BroadcastMessageEvent event, ELConfig config, Logger logger) {
        String message = "*[BROADCAST]* " + StringUtils.removeSpecialChars(((TextComponent)event.message()).content());
        this.postMessage(message, config.getSlackChannelId(), config.getSlackAPIToken());
    }
}

