/*
 * Decompiled with CFR 0.152.
 */
package com.hidethemonkey.elfim.messaging.json;

import com.hidethemonkey.elfim.ELConfig;
import com.hidethemonkey.elfim.helpers.MD5Util;
import com.hidethemonkey.elfim.messaging.json.DiscordMessage;
import com.hidethemonkey.elfim.messaging.json.Embed;
import java.util.logging.Logger;

public class DiscordMessageFactory {
    private ELConfig config;
    private Logger logger;
    private String botUserName;
    private String botAvatarUrl;
    private String gravatarEmail;
    private boolean useGravatar = false;

    public DiscordMessageFactory(ELConfig config, Logger logger) {
        this.config = config;
        this.logger = logger;
        this.botUserName = config.getDiscordBotName();
        this.botAvatarUrl = config.getDiscordAvatarUrl();
        this.gravatarEmail = config.getGravatarEmail();
        boolean discordEnabled = config.getDiscordEnabled();
        if (this.gravatarEmail.equals("replace-me")) {
            this.gravatarEmail = null;
        } else {
            this.useGravatar = true;
        }
        if (!this.useGravatar && this.botAvatarUrl.equals("replace-me")) {
            if (discordEnabled) {
                logger.info("botAvatarUrl is not set in config.yml.");
            }
            this.botAvatarUrl = null;
        }
        if (this.useGravatar) {
            this.botAvatarUrl = config.getGravatarUrl() + MD5Util.md5Hex(this.gravatarEmail);
        }
    }

    public DiscordMessage getMessage() {
        return new DiscordMessage(this.botUserName, this.botAvatarUrl);
    }

    public DiscordMessage getMessage(String content) {
        DiscordMessage message = new DiscordMessage(this.botUserName, this.botAvatarUrl);
        message.setContent(content);
        return message;
    }

    public DiscordMessage getMessage(Embed embed) {
        DiscordMessage message = new DiscordMessage(this.botUserName, this.botAvatarUrl);
        message.addEmbed(embed);
        return message;
    }
}

