/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.audit.impl;

import com.slack.api.SlackConfig;
import com.slack.api.audit.AuditApiCompletionException;
import com.slack.api.audit.AuditApiException;
import com.slack.api.audit.AuditApiResponse;
import com.slack.api.audit.AuditConfig;
import com.slack.api.audit.impl.AsyncExecutionSupplier;
import com.slack.api.audit.impl.AsyncRateLimitQueue;
import com.slack.api.audit.impl.ThreadPools;
import com.slack.api.methods.impl.MethodsClientImpl;
import com.slack.api.methods.impl.TeamIdCache;
import com.slack.api.rate_limits.metrics.MetricsDatastore;
import com.slack.api.rate_limits.queue.MessageIdGenerator;
import com.slack.api.rate_limits.queue.MessageIdGeneratorUUIDImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncRateLimitExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncRateLimitExecutor.class);
    private static final ConcurrentMap<String, AsyncRateLimitExecutor> ALL_EXECUTORS = new ConcurrentHashMap<String, AsyncRateLimitExecutor>();
    private AuditConfig config;
    private MetricsDatastore metricsDatastore;
    private final TeamIdCache teamIdCache;
    private final MessageIdGenerator messageIdGenerator;
    private static final List<String> NO_TOKEN_METHOD_NAMES = Arrays.asList("schemas", "actions");

    private AsyncRateLimitExecutor(MethodsClientImpl methods, SlackConfig config) {
        this.config = config.getAuditConfig();
        this.metricsDatastore = config.getAuditConfig().getMetricsDatastore();
        this.teamIdCache = new TeamIdCache(methods);
        this.messageIdGenerator = new MessageIdGeneratorUUIDImpl();
    }

    public static AsyncRateLimitExecutor get(String executorName) {
        return (AsyncRateLimitExecutor)ALL_EXECUTORS.get(executorName);
    }

    public static AsyncRateLimitExecutor getOrCreate(MethodsClientImpl methods, SlackConfig config) {
        AsyncRateLimitExecutor executor = (AsyncRateLimitExecutor)ALL_EXECUTORS.get(config.getAuditConfig().getExecutorName());
        if (executor != null && executor.metricsDatastore != config.getAuditConfig().getMetricsDatastore()) {
            executor.config = config.getAuditConfig();
            executor.metricsDatastore = config.getAuditConfig().getMetricsDatastore();
        }
        if (executor == null) {
            executor = new AsyncRateLimitExecutor(methods, config);
            ALL_EXECUTORS.putIfAbsent(config.getAuditConfig().getExecutorName(), executor);
        }
        return executor;
    }

    public <T extends AuditApiResponse> CompletableFuture<T> execute(String methodName, Map<String, String> params, AsyncExecutionSupplier<T> methodsSupplier) {
        String token = params.get("token");
        String teamId = token != null ? this.teamIdCache.lookupOrResolve(token) : null;
        ExecutorService executorService = teamId != null ? ThreadPools.getOrCreate(this.config, teamId) : ThreadPools.getDefault(this.config);
        return CompletableFuture.supplyAsync(() -> {
            String messageId = this.messageIdGenerator.generate();
            this.addMessageId(teamId, methodName, messageId);
            this.syncCurrentQueueSizeStats(teamId, methodName);
            if (NO_TOKEN_METHOD_NAMES.contains(methodName) || teamId == null) {
                return this.runWithoutQueue(teamId, methodName, methodsSupplier);
            }
            return this.enqueueThenRun(messageId, teamId, methodName, params, methodsSupplier);
        }, executorService);
    }

    private void syncCurrentQueueSizeStats(String teamId, String methodNameWithSuffix) {
        if (teamId != null) {
            this.metricsDatastore.updateCurrentQueueSize(this.config.getExecutorName(), teamId, methodNameWithSuffix);
        }
    }

    private void addMessageId(String teamId, String methodNameWithSuffix, String messageId) {
        this.metricsDatastore.addToWaitingMessageIds(this.config.getExecutorName(), teamId, methodNameWithSuffix, messageId);
    }

    private void removeMessageId(String teamId, String methodNameWithSuffix, String messageId) {
        this.metricsDatastore.deleteFromWaitingMessageIds(this.config.getExecutorName(), teamId, methodNameWithSuffix, messageId);
    }

    public <T extends AuditApiResponse> T runWithoutQueue(String teamId, String methodName, AsyncExecutionSupplier<T> methodsSupplier) {
        try {
            return methodsSupplier.execute();
        }
        catch (RuntimeException e) {
            return AsyncRateLimitExecutor.handleRuntimeException(teamId, methodName, e);
        }
        catch (IOException e) {
            return AsyncRateLimitExecutor.handleIOException(teamId, methodName, e);
        }
        catch (AuditApiException e) {
            AsyncRateLimitExecutor.logAuditApiException(teamId, methodName, e);
            throw new AuditApiCompletionException(null, e, null);
        }
    }

    private <T extends AuditApiResponse> T enqueueThenRun(String messageId, String teamId, String methodName, Map<String, String> params, AsyncExecutionSupplier<T> methodsSupplier) {
        try {
            AsyncRateLimitQueue activeQueue = AsyncRateLimitQueue.getOrCreate(this.config, teamId);
            if (activeQueue == null) {
                log.warn("Queue for teamId: {} was not found. Going to run the API call immediately.", (Object)teamId);
            }
            AsyncExecutionSupplier supplier = null;
            activeQueue.enqueue(messageId, teamId, methodName, params, methodsSupplier);
            for (long consumedMillis = 0L; supplier == null && consumedMillis < (long)this.config.getMaxIdleMills(); consumedMillis += 10L) {
                Thread.sleep(10L);
                supplier = (AsyncExecutionSupplier)activeQueue.dequeueIfReady(messageId, teamId, methodName, params);
                this.removeMessageId(teamId, methodName, messageId);
            }
            if (supplier == null) {
                activeQueue.remove(methodName, messageId);
                throw new RejectedExecutionException("Gave up executing the message after " + this.config.getMaxIdleMills() + " milliseconds.");
            }
            Object response = supplier.execute();
            return response;
        }
        catch (RuntimeException e) {
            return AsyncRateLimitExecutor.handleRuntimeException(teamId, methodName, e);
        }
        catch (IOException e) {
            return AsyncRateLimitExecutor.handleIOException(teamId, methodName, e);
        }
        catch (AuditApiException e) {
            AsyncRateLimitExecutor.logAuditApiException(teamId, methodName, e);
            if (e.getResponse().code() == 429) {
                return this.enqueueThenRun(messageId, teamId, methodName, params, methodsSupplier);
            }
            throw new AuditApiCompletionException(null, e, null);
        }
        catch (InterruptedException e) {
            log.error("Got an InterruptedException (error: {})", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static <T extends AuditApiResponse> T handleRuntimeException(String teamId, String methodName, RuntimeException e) {
        log.error("Got an exception while calling {} API (team: {}, error: {})", methodName, teamId, e.getMessage(), e);
        throw new AuditApiCompletionException(null, null, e);
    }

    private static <T extends AuditApiResponse> T handleIOException(String teamId, String methodName, IOException e) {
        log.error("Failed to connect to {} API (team: {}, error: {})", methodName, teamId, e.getMessage(), e);
        throw new AuditApiCompletionException(e, null, null);
    }

    private static void logAuditApiException(String teamId, String methodName, AuditApiException e) {
        if (e.getResponse().code() == 429) {
            String retryAfterSeconds = e.getResponse().header("Retry-After");
            log.error("Got a rate-limited response from {} API (team: {}, error: {}, retry-after: {})", methodName, teamId, e.getMessage(), retryAfterSeconds, e);
        } else {
            log.error("Got an unsuccessful response from {} API (team: {}, error: {}, status code: {})", methodName, teamId, e.getMessage(), e.getResponse().code(), e);
        }
    }
}

