/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.rate_limits;

import com.slack.api.methods.MethodsRateLimitTier;
import com.slack.api.rate_limits.WaitTime;
import com.slack.api.rate_limits.metrics.LastMinuteRequests;
import com.slack.api.rate_limits.metrics.RequestPace;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WaitTimeCalculator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WaitTimeCalculator.class);

    public abstract Integer getNumberOfNodes();

    public abstract String getExecutorName();

    public abstract Optional<Long> getRateLimitedMethodRetryEpochMillis(String var1, String var2, String var3);

    public abstract LastMinuteRequests getLastMinuteRequests(String var1, String var2, String var3);

    public WaitTime calculateWaitTime(String teamId, String key, int allowedRequests) {
        LastMinuteRequests lastMinuteRequests = this.getLastMinuteRequests(this.getExecutorName(), teamId, key);
        if (this.isBurst(lastMinuteRequests, allowedRequests)) {
            if (log.isDebugEnabled()) {
                log.debug("Burst requests detected (method: {}, last minute requests: {}, allowed: {})", key, lastMinuteRequests.size(), allowedRequests);
            }
            Double waitMillis = 180000.0 / (double)allowedRequests;
            return new WaitTime(waitMillis.longValue(), RequestPace.Burst);
        }
        if (WaitTimeCalculator.isTooFastPaced(lastMinuteRequests, allowedRequests)) {
            Double waitMillis = 120000.0 / (double)allowedRequests;
            return new WaitTime(waitMillis.longValue(), RequestPace.TooFastPaced);
        }
        if (WaitTimeCalculator.isOptimalPace(lastMinuteRequests, allowedRequests)) {
            Double waitMillis = 60000.0 / (double)allowedRequests;
            return new WaitTime(waitMillis.longValue(), RequestPace.Optimal);
        }
        if (WaitTimeCalculator.isSomewhatBusy(lastMinuteRequests, allowedRequests)) {
            Double waitMillis = 30000.0 / (double)allowedRequests;
            return new WaitTime(waitMillis.longValue(), RequestPace.Safe);
        }
        return new WaitTime(0L, RequestPace.Safe);
    }

    @Deprecated
    public WaitTime calculateWaitTimeForChatPostMessage(String teamId, String channel) {
        return this.calculateWaitTimeForChatPostMessage(teamId, channel, this.getAllowedRequestsPerMinute(MethodsRateLimitTier.SpecialTier_chat_postMessage));
    }

    public WaitTime calculateWaitTimeForChatPostMessage(String teamId, String channel, int allowedRequests) {
        return this.calculateWaitTime(teamId, "chat.postMessage_" + channel, allowedRequests);
    }

    public WaitTime calculateWaitTimeForAssistantThreadsSetStatus(String teamId, String channel, int allowedRequests) {
        return this.calculateWaitTime(teamId, "assistant.threads.setStatus_" + channel, allowedRequests);
    }

    private boolean isBurst(LastMinuteRequests lastMinuteRequests, int allowedRequests) {
        if (lastMinuteRequests.size() > allowedRequests / 10) {
            long threeSecondsAgo = System.currentTimeMillis() - 3000L;
            long burstRequests = lastMinuteRequests.stream().filter(millis -> millis > threeSecondsAgo).count();
            return burstRequests >= (long)(allowedRequests / 10);
        }
        return false;
    }

    private static boolean isSomewhatBusy(LastMinuteRequests lastMinuteRequests, int allowedRequests) {
        int currentSize = lastMinuteRequests.size();
        return (double)currentSize >= (double)allowedRequests * 0.3 && (double)currentSize < (double)allowedRequests * 0.6;
    }

    private static boolean isOptimalPace(LastMinuteRequests lastMinuteRequests, int allowedRequests) {
        int currentSize = lastMinuteRequests.size();
        return (double)currentSize >= (double)allowedRequests * 0.6 && (double)currentSize < (double)allowedRequests * 0.9;
    }

    private static boolean isTooFastPaced(LastMinuteRequests lastMinuteRequests, int allowedRequests) {
        return (double)lastMinuteRequests.size() >= (double)allowedRequests * 0.9;
    }

    public Integer getAllowedRequestsPerMinute(MethodsRateLimitTier tier) {
        Integer allowedRequestsPerMinute = MethodsRateLimitTier.getAllowedRequestsPerMinute(tier);
        return allowedRequestsPerMinute / this.getNumberOfNodes();
    }
}

