/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.slack.api.model.admin.AppWorkflow;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.util.json.GsonFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonAppWorkflowStepInputValueFactory
implements JsonDeserializer<AppWorkflow.StepInputValue>,
JsonSerializer<AppWorkflow.StepInputValue> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GsonAppWorkflowStepInputValueFactory.class);
    private static final String REPORT_THIS = "Please report this issue at https://github.com/slackapi/java-slack-sdk/issues";
    private final boolean failOnUnknownProperties;
    private static final Gson GSON = GsonFactory.createSnakeCase();
    private static final Type TYPE = new TypeToken<List<String>>(){}.getType();

    public GsonAppWorkflowStepInputValueFactory() {
        this(false);
    }

    public GsonAppWorkflowStepInputValueFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    @Override
    public AppWorkflow.StepInputValue deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        AppWorkflow.StepInputValue result = new AppWorkflow.StepInputValue();
        if (json.isJsonPrimitive()) {
            result.setStringValue(json.getAsString());
            return result;
        }
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            if (obj.get("required") != null && obj.get("required").isJsonArray()) {
                result.setRequired(this.parseStringArray(obj.get("required")));
            }
            if (obj.get("elements") != null && obj.get("elements").isJsonArray()) {
                result.setElements(this.parseElements(obj.get("elements")));
            }
            return result;
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            if (array == null || array.size() == 0) {
                return result;
            }
            if (array.get(0).isJsonObject()) {
                result.setInteractiveBlocks(this.parseInteractiveBlocks(json));
            } else if (array.get(0).isJsonPrimitive()) {
                result.setStringValues(this.parseStringArray(json));
            }
            return result;
        }
        if (this.failOnUnknownProperties) {
            String message = "The whole value (" + json + ") is unsupported. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return result;
    }

    private List<AppWorkflow.StepInputValueElement> parseElements(JsonElement json) throws JsonParseException {
        ArrayList<AppWorkflow.StepInputValueElement> values = new ArrayList<AppWorkflow.StepInputValueElement>();
        for (JsonElement elem : json.getAsJsonArray()) {
            if (elem.isJsonObject()) {
                values.add(GSON.fromJson(elem, AppWorkflow.StepInputValueElement.class));
                continue;
            }
            if (!this.failOnUnknownProperties) continue;
            String message = "An unexpected element (" + elem + ") in an array is detected. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return values;
    }

    private List<String> parseStringArray(JsonElement json) throws JsonParseException {
        ArrayList<String> values = new ArrayList<String>();
        for (JsonElement elem : json.getAsJsonArray()) {
            if (elem.isJsonPrimitive()) {
                values.add(elem.getAsString());
                continue;
            }
            if (!this.failOnUnknownProperties) continue;
            String message = "An unexpected element (" + elem + ") in an array is detected. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return values;
    }

    private List<LayoutBlock> parseInteractiveBlocks(JsonElement json) throws JsonParseException {
        ArrayList<LayoutBlock> values = new ArrayList<LayoutBlock>();
        for (JsonElement elem : json.getAsJsonArray()) {
            if (elem.isJsonObject()) {
                values.add(GSON.fromJson(elem, LayoutBlock.class));
                continue;
            }
            if (!this.failOnUnknownProperties) continue;
            String message = "An unexpected element (" + elem + ") in an array is detected. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return values;
    }

    @Override
    public JsonElement serialize(AppWorkflow.StepInputValue src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray array = new JsonArray();
        for (AppWorkflow.StepInputValueElement value : src.getElements()) {
            array.add(GSON.toJson(value));
        }
        return array;
    }
}

