package io.github.therookiecoder.snowyleavesplus;

import net.minecraft.class_2754;
import net.minecraft.class_3542;

public enum Snowiness implements class_3542 {
    none,
    low,
    medium,
    high,
    full;

    public static final class_2754<Snowiness> SNOWINESS =
        class_2754.method_11850("snowiness", Snowiness.class);

    @Override
    public String method_15434() {
        return this.name();
    }

    /**
     * Increment snowiness by one.
     * Returns the same value if it is already at the maximum level
     * @return The current snowiness value increased by one
     */
    public Snowiness increaseSnowiness() {
        if (this.ordinal() + 1 < Snowiness.values().length) {
            return Snowiness.values()[this.ordinal() + 1];
        } else {
            return this;
        }
    }

    /**
     * Decrement snowiness by one.
     * Returns the same value if it is already at the minimum level
     * @return The current snowiness value decreased by one
     */
    public Snowiness decreaseSnowiness() {
        if (this.ordinal() > 0) {
            return Snowiness.values()[this.ordinal() - 1];
        } else {
            return this;
        }
    }
}
