package io.github.therookiecoder.snowyleavesplus;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1926;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import static io.github.therookiecoder.snowyleavesplus.Snowiness.SNOWINESS;

public class SnowyLeavesPlusClient implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void onInitializeClient() {
        ColorProviderRegistry.BLOCK.register(
            (state, world, pos, index) -> {
                // Get the block's default colour
                int colour = getLeafBlockColour(state.method_26204(), world, pos);
                try {
                    return whiten(colour,
                        (double) state.method_11654(SNOWINESS).ordinal() / Snowiness.values().length);
                    // If there is any error, return the default colour
                } catch (Exception e) {
                    LOGGER.error("Could not get SNOWINESS block state");
                    LOGGER.error(e);
                    return colour;
                }
            },
            class_2246.field_10503,
            class_2246.field_9988,
            class_2246.field_10539,
            class_2246.field_10335,
            class_2246.field_10098,
            class_2246.field_10035,
            class_2246.field_37551,
            class_2246.field_28673,
            class_2246.field_28674
        );
    }

    /**
     * Based on code from Minecraft's registered colour providers.
     *
     * @param block The block to get the colour of
     * @param world The current world
     * @param pos   The position of the block
     * @return The leaf block's default colour.
     * @see net.minecraft.class_324
     */
    private int getLeafBlockColour(class_2248 block, class_1920 world, class_2338 pos) {
        if (block == class_2246.field_10539) {
            return class_1926.field_55216;
        } else if (block == class_2246.field_9988) {
            return class_1926.field_55215;
        } else if (block == class_2246.field_37551) {
            return class_1926.field_55218;
        } else if (world != null && pos != null) {
            return class_1163.method_4966(world, pos);
        } else {
            return class_1926.field_55217;
        }
    }

    /**
     * Whiten a colour based on a whiteness value
     *
     * @param colour    The colour to modify
     * @param whiteness The amount to whiten the colour by.
     *                  A whiteness of <code>0</code> would return the same colour, and a
     *                  whiteness of <code>1</code> would return white (<code>0xffffff</code>)
     * @return The whitened colour
     */
    private int whiten(int colour, double whiteness) {
        assert whiteness >= 0;
        assert whiteness <= 1;

        // Extract colour channels
        int red = (colour >> 16 & 0xff);
        int green = (colour >> 8 & 0xff);
        int blue = (colour & 0xff);

        // Find out how far the colour is from white and interpolate based on the provided whiteness
        red += (0xff - red) * whiteness;
        green += (0xff - green) * whiteness;
        blue += (0xff - blue) * whiteness;

        // Combine the colours back
        return red << 16 | green << 8 | blue;
    }
}
