package io.github.therookiecoder.snowyleavesplus.mixin;

import io.github.therookiecoder.snowyleavesplus.Snowiness;
import net.minecraft.block.*;
import net.minecraft.class_10716;
import net.minecraft.class_10717;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_7114;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static io.github.therookiecoder.snowyleavesplus.Snowiness.SNOWINESS;


@Mixin(class_2248.class)
interface BlockInvoker {
    @Invoker("setDefaultState")
    void invokeSetDefaultState(class_2680 state);
}

@Mixin(class_2397.class)
public abstract class LeavesBlockMixin {
    @Unique
    boolean shouldModify() {
        return this.getClass().equals(class_10716.class)
            || this.getClass().equals(class_10717.class)
            || this.getClass().equals(class_7114.class);
    }

    // Add the snowiness property to leaf blocks
    @Inject(method = "appendProperties", at = @At("TAIL"))
    private void appendPropertiesInject(class_2689.class_2690<class_2248, class_2680> builder, CallbackInfo ci) {
        if (!shouldModify()) return;
        builder.method_11667(SNOWINESS);
    }

    // Set the default snowiness to none
    @Inject(method = "<init>", at = @At("TAIL"))
    private void initInject(float leafParticleChance, class_4970.class_2251 settings, CallbackInfo ci) {
        if (!shouldModify()) return;
        ((BlockInvoker) this)
            .invokeSetDefaultState(
                ((class_2248) (Object) this)
                    .method_9564().method_11657(
                        SNOWINESS,
                        Snowiness.none
                    )
            );
    }

    // Always randomly tick appropriate blocks
    @Inject(method = "hasRandomTicks", at = @At("RETURN"), cancellable = true)
    private void hasRandomTicksInject(class_2680 state, CallbackInfoReturnable<Boolean> cir) {
        if (shouldModify()) {
            cir.setReturnValue(true);
        }
    }

    @Inject(method = "randomTick", at = @At("HEAD"))
    private void randomTickInject(
        class_2680 state,
        class_3218 world,
        class_2338 pos,
        class_5819 random,
        CallbackInfo ci
    ) {
        if (!shouldModify()) return;

        if (
            // If it's 'raining'
            world.method_8419()
                // And the block is in a snowy biome
                && world.method_23753(pos).comp_349().method_48162(pos, world.method_8615()) == class_1959.class_1963.field_9383
                // And the block is (somewhat) exposed to the sky
                && world.method_8314(class_1944.field_9284, pos) > 10
        ) {
            // Make it more snowy
            world.method_8501(pos, state.method_11657(SNOWINESS, state.method_11654(SNOWINESS).increaseSnowiness()));
        } else {
            // Else make it less snowy
            world.method_8501(pos, state.method_11657(SNOWINESS, state.method_11654(SNOWINESS).decreaseSnowiness()));
        }
    }
}
