/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class RandomStructureBlock
extends Block {
    public RandomStructureBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 6.0f).func_226896_b_());
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.field_72995_K) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 100 + new Random().nextInt(100));
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        Random random = new Random();
        if (random.nextDouble() < 0.3) {
            ResourceLocation villageLocation = this.getRandomVillageJigsaw(world);
            if (villageLocation != null) {
                System.out.println("Attempting to spawn village: " + villageLocation);
                this.spawnVillageStructure(world, pos, villageLocation);
            } else {
                System.out.println("No village jigsaw pool found.");
            }
        } else if (random.nextBoolean()) {
            ResourceLocation jigsawStructureLocation = this.getRandomJigsawStructure(world);
            System.out.println("Attempting to spawn jigsaw structure: " + jigsawStructureLocation);
            boolean jigsawSuccess = this.spawnJigsawStructure(world, pos, jigsawStructureLocation);
            if (!jigsawSuccess) {
                ResourceLocation templateStructureLocation = this.getRandomTemplateStructure();
                System.out.println("Jigsaw failed, attempting to spawn template structure: " + templateStructureLocation);
                this.spawnTemplateStructure(world, pos, templateStructureLocation);
            }
        } else {
            ResourceLocation templateStructureLocation = this.getRandomTemplateStructure();
            System.out.println("Attempting to spawn template structure: " + templateStructureLocation);
            boolean templateSuccess = this.spawnTemplateStructure(world, pos, templateStructureLocation);
            if (!templateSuccess) {
                ResourceLocation jigsawStructureLocation = this.getRandomJigsawStructure(world);
                System.out.println("Template failed, attempting to spawn jigsaw structure: " + jigsawStructureLocation);
                this.spawnJigsawStructure(world, pos, jigsawStructureLocation);
            }
        }
        world.func_217377_a(pos, false);
    }

    private ResourceLocation getRandomVillageJigsaw(ServerWorld world) {
        DynamicRegistries dynamicRegistryManager = world.func_241828_r();
        MutableRegistry jigsawPoolRegistry = dynamicRegistryManager.func_243612_b(Registry.field_243555_ax);
        ArrayList<ResourceLocation> villagePoolList = new ArrayList<ResourceLocation>();
        for (ResourceLocation pool : jigsawPoolRegistry.func_148742_b()) {
            if (!pool.func_110623_a().contains("village/")) continue;
            villagePoolList.add(pool);
        }
        if (villagePoolList.isEmpty()) {
            return null;
        }
        Random random = new Random();
        return (ResourceLocation)villagePoolList.get(random.nextInt(villagePoolList.size()));
    }

    private void spawnVillageStructure(ServerWorld world, BlockPos blockPos, ResourceLocation villageJigsawLocation) {
        DynamicRegistries dynamicRegistryManager = world.func_241828_r();
        MutableRegistry templatePoolRegistry = dynamicRegistryManager.func_243612_b(Registry.field_243555_ax);
        JigsawPattern startPool = (JigsawPattern)templatePoolRegistry.func_82594_a(villageJigsawLocation);
        if (startPool != null) {
            System.out.println("Successfully loaded village jigsaw pool: " + villageJigsawLocation);
            VillageConfig villageConfig = new VillageConfig(() -> startPool, 10);
            ArrayList structurePieces = new ArrayList();
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)villageConfig, AbstractVillagePiece::new, (ChunkGenerator)world.func_72863_F().func_201711_g(), (TemplateManager)world.func_184163_y(), (BlockPos)blockPos, structurePieces, (Random)world.func_201674_k(), (boolean)true, (boolean)true);
            for (StructurePiece piece : structurePieces) {
                piece.func_230383_a_((ISeedReader)world, world.func_241112_a_(), world.func_72863_F().func_201711_g(), world.func_201674_k(), piece.func_74874_b(), world.func_217349_x(blockPos).func_76632_l(), blockPos);
            }
            System.out.println("Village structure placed at: " + blockPos);
        } else {
            System.out.println("Failed to load village jigsaw pool for: " + villageJigsawLocation);
        }
    }

    private boolean spawnTemplateStructure(ServerWorld world, BlockPos blockPos, ResourceLocation structureLocation) {
        TemplateManager templateManager = world.func_184163_y();
        Template template = templateManager.func_200219_b(structureLocation);
        if (template != null) {
            PlacementSettings placementSettings = new PlacementSettings().func_186222_a(false).func_186220_a(Rotation.func_222466_a((Random)new Random())).func_186214_a(Mirror.values()[new Random().nextInt(Mirror.values().length)]);
            int groundY = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, blockPos.func_177958_n(), blockPos.func_177952_p());
            BlockPos spawnPos = new BlockPos(blockPos.func_177958_n(), groundY, blockPos.func_177952_p());
            template.func_237146_a_((IServerWorld)world, spawnPos, spawnPos, placementSettings, world.func_201674_k(), 3);
            System.out.println("Template structure placed at: " + spawnPos);
            return true;
        }
        System.out.println("Failed to load template for: " + structureLocation);
        return false;
    }

    private boolean spawnJigsawStructure(ServerWorld world, BlockPos blockPos, ResourceLocation jigsawPoolLocation) {
        DynamicRegistries dynamicRegistryManager = world.func_241828_r();
        MutableRegistry templatePoolRegistry = dynamicRegistryManager.func_243612_b(Registry.field_243555_ax);
        JigsawPattern startPool = (JigsawPattern)templatePoolRegistry.func_82594_a(jigsawPoolLocation);
        if (startPool != null) {
            System.out.println("Successfully loaded jigsaw pool: " + jigsawPoolLocation);
            VillageConfig villageConfig = new VillageConfig(() -> startPool, 10);
            ArrayList structurePieces = new ArrayList();
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)villageConfig, AbstractVillagePiece::new, (ChunkGenerator)world.func_72863_F().func_201711_g(), (TemplateManager)world.func_184163_y(), (BlockPos)blockPos, structurePieces, (Random)world.func_201674_k(), (boolean)false, (boolean)false);
            for (StructurePiece piece : structurePieces) {
                BlockPos groundPos = new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
                if (groundPos.func_177956_o() > 0) {
                    piece.func_230383_a_((ISeedReader)world, world.func_241112_a_(), world.func_72863_F().func_201711_g(), world.func_201674_k(), piece.func_74874_b(), world.func_217349_x(groundPos).func_76632_l(), groundPos);
                    continue;
                }
                System.out.println("Invalid height for structure, skipping piece placement.");
            }
            System.out.println("Jigsaw structure placed at: " + blockPos);
            return true;
        }
        System.out.println("Failed to load jigsaw pool for: " + jigsawPoolLocation);
        return false;
    }

    private ResourceLocation getRandomJigsawStructure(ServerWorld world) {
        DynamicRegistries dynamicRegistryManager = world.func_241828_r();
        MutableRegistry jigsawPoolRegistry = dynamicRegistryManager.func_243612_b(Registry.field_243555_ax);
        ArrayList<ResourceLocation> jigsawPoolList = new ArrayList<ResourceLocation>(jigsawPoolRegistry.func_148742_b());
        Random random = new Random();
        jigsawPoolList.removeIf(pool -> pool.toString().equals("minecraft:empty") || pool.func_110623_a().contains("village/"));
        return (ResourceLocation)jigsawPoolList.get(random.nextInt(jigsawPoolList.size()));
    }

    private ResourceLocation getRandomTemplateStructure() {
        ArrayList templateList = new ArrayList(ForgeRegistries.STRUCTURE_FEATURES.getKeys());
        Random random = new Random();
        return (ResourceLocation)templateList.get(random.nextInt(templateList.size()));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List dropsOriginal = super.func_220076_a(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((IItemProvider)this, 1));
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("\u00a7bSpawns any structure in the game\u00a7b"));
    }
}

