/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.entity;

import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class Butterfly
extends CreatureEntity {
    private static final DataParameter<Byte> FLYING = EntityDataManager.func_187226_a(Butterfly.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final EntityPredicate field_213813_c = new EntityPredicate().func_221013_a(4.0).func_221011_b();
    private BlockPos spawnPosition;
    private static final DataParameter<Integer> BUTTERFLY_VARIANT = EntityDataManager.func_187226_a(Butterfly.class, (IDataSerializer)DataSerializers.field_187192_b);

    public Butterfly(EntityType<? extends Butterfly> type, World worldIn) {
        super(type, worldIn);
        this.field_70158_ak = true;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
    }

    public int getButterflyVariant() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(BUTTERFLY_VARIANT)), (int)0, (int)4);
    }

    public void setButterflyVariant(int variant) {
        this.field_70180_af.func_187227_b(BUTTERFLY_VARIANT, (Object)variant);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BUTTERFLY_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(FLYING, (Object)0);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setButterflyVariant(compound.func_74762_e("Variant"));
        this.field_70180_af.func_187227_b(FLYING, (Object)compound.func_74771_c("ButterflyFlags"));
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 2.0).func_233815_a_(Attributes.field_233821_d_, (double)0.1f).func_233815_a_(Attributes.field_233822_e_, (double)0.1f).func_233815_a_(Attributes.field_233826_i_, 0.5);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance diff, SpawnReason spawn, @Nullable ILivingEntityData spawndata, @Nullable CompoundNBT comnbt) {
        int x;
        if (spawndata instanceof ButterflyData) {
            x = ((ButterflyData)((Object)spawndata)).variant;
        } else {
            x = this.field_70146_Z.nextInt(4);
            spawndata = new ButterflyData(x);
        }
        this.setButterflyVariant(x);
        return super.func_213386_a(world, diff, spawn, spawndata, comnbt);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    protected float func_70647_i() {
        return 0.7f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return true;
    }

    protected boolean func_225511_J_() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    public boolean getIsButterflyHanging() {
        return ((Byte)this.field_70180_af.func_187225_a(FLYING) & 1) != 0;
    }

    public void setIsButterflyHanging(boolean isHanging) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(FLYING);
        if (isHanging) {
            this.field_70180_af.func_187227_b(FLYING, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(FLYING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getIsButterflyHanging()) {
            this.func_213317_d(Vector3d.field_186680_a);
            this.func_226288_n_(this.func_226277_ct_(), (double)MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1.0 - (double)this.func_213302_cg(), this.func_226281_cx_());
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = this.func_233580_cy_();
        BlockPos blockpos1 = blockpos.func_177984_a();
        if (this.getIsButterflyHanging()) {
            boolean flag = this.func_174814_R();
            if (this.field_70170_p.func_180495_p(blockpos1).func_215686_e((IBlockReader)this.field_70170_p, blockpos)) {
                if (this.field_70146_Z.nextInt(200) == 0) {
                    this.field_70759_as = this.field_70146_Z.nextInt(360);
                }
                if (this.field_70170_p.func_217370_a(field_213813_c, (LivingEntity)this) != null) {
                    this.setIsButterflyHanging(false);
                    if (!flag) {
                        this.field_70170_p.func_217378_a((PlayerEntity)null, 1025, blockpos, 0);
                    }
                }
            } else {
                this.setIsButterflyHanging(false);
                if (!flag) {
                    this.field_70170_p.func_217378_a((PlayerEntity)null, 1025, blockpos, 0);
                }
            }
        } else {
            if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
                this.spawnPosition = null;
            }
            if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_218137_a((IPosition)this.func_213303_ch(), 2.0)) {
                this.spawnPosition = new BlockPos(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7), this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(6) - 2.0, this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7));
            }
            double d2 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.func_226277_ct_();
            double d0 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.func_226278_cu_();
            double d1 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.func_226281_cx_();
            Vector3d vector3d = this.func_213322_ci();
            Vector3d vector3d1 = vector3d.func_72441_c((Math.signum(d2) * 0.5 - vector3d.field_72450_a) * (double)0.1f, (Math.signum(d0) * (double)0.7f - vector3d.field_72448_b) * (double)0.1f, (Math.signum(d1) * 0.5 - vector3d.field_72449_c) * (double)0.1f);
            this.func_213317_d(vector3d1);
            float f = (float)(MathHelper.func_181159_b((double)vector3d1.field_72449_c, (double)vector3d1.field_72450_a) * 57.2957763671875) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += f1;
            if (this.field_70146_Z.nextInt(100) == 0 && this.field_70170_p.func_180495_p(blockpos1).func_215686_e((IBlockReader)this.field_70170_p, blockpos1)) {
                this.setIsButterflyHanging(true);
            }
        }
    }

    public void func_213281_b(CompoundNBT comnbt) {
        super.func_213281_b(comnbt);
        comnbt.func_74768_a("Variant", this.getButterflyVariant());
    }

    static class ButterflyData
    extends AgeableEntity.AgeableData {
        public final int variant;

        private ButterflyData(int x) {
            super(false);
            this.variant = x;
        }
    }
}

