/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.entity;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class EasterBunny
extends RabbitEntity {
    private static final DataParameter<Integer> EASTER_BUNNY_VARIANT = EntityDataManager.func_187226_a(EasterBunny.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int eggTime;

    public EasterBunny(EntityType<? extends EasterBunny> type, World worldIn) {
        super(type, worldIn);
        this.eggTime = this.field_70146_Z.nextInt(450) + 450;
        this.field_70728_aV = 2;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.22).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233826_i_, 3.5);
    }

    public int getEasterBunnyVariant() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(EASTER_BUNNY_VARIANT)), (int)0, (int)2);
    }

    public void setEasterBunnyVariant(int variant) {
        this.field_70180_af.func_187227_b(EASTER_BUNNY_VARIANT, (Object)variant);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EASTER_BUNNY_VARIANT, (Object)0);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setEasterBunnyVariant(compound.func_74762_e("Variant"));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 7.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance diff, SpawnReason spawn, @Nullable ILivingEntityData spawndata, @Nullable CompoundNBT comnbt) {
        int x;
        if (spawndata instanceof EasterBunnyData) {
            x = ((EasterBunnyData)((Object)spawndata)).variant;
        } else {
            x = this.field_70146_Z.nextInt(2);
            spawndata = new EasterBunnyData(x);
        }
        this.setEasterBunnyVariant(x);
        return super.func_213386_a(world, diff, spawn, spawndata, comnbt);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187822_em;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187820_el;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    protected float func_70647_i() {
        return 0.7f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && --this.eggTime <= 0) {
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_199701_a_(this.randomEgg());
            this.eggTime = this.field_70146_Z.nextInt(450) + 450;
        }
    }

    public ItemStack randomEgg() {
        ArrayList<Item> itemList = new ArrayList<Item>(ForgeRegistries.ITEMS.getValues());
        itemList.removeIf(item -> {
            ResourceLocation registryName = item.getRegistryName();
            if (registryName == null) {
                return true;
            }
            String path = registryName.func_110623_a();
            return !path.contains("_spawn_egg") && !path.contains("spawn_egg_");
        });
        Item randomItem = (Item)itemList.get(this.field_70146_Z.nextInt(itemList.size()));
        return randomItem.func_190903_i();
    }

    public void func_213281_b(CompoundNBT comnbt) {
        super.func_213281_b(comnbt);
        comnbt.func_74768_a("Variant", this.getEasterBunnyVariant());
    }

    static class EasterBunnyData
    extends AgeableEntity.AgeableData {
        public final int variant;

        private EasterBunnyData(int x) {
            super(false);
            this.variant = x;
        }
    }
}

