/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.entity;

import com.devmaster.dangerzone.entity.NotBreeBree;
import com.devmaster.dangerzone.entity.StampyLongNose;
import com.devmaster.dangerzone.entity.WaterProjectile;
import com.devmaster.dangerzone.entity.goals.IntervalRangedAttackGoal;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedRoseWarrior
extends CreatureEntity
implements IRangedAttackMob {
    private static final int MAX_BEND_TIME = 66;
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(RedRoseWarrior.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_STATE = "RRWState";
    private static final byte STILL = 0;
    private static final byte BENDING = 2;
    private static final byte BENDING_CLIENT = 9;
    private final ServerBossInfo bossInfo = new ServerBossInfo((ITextComponent)this.func_145748_c_().func_230531_f_().func_240699_a_(TextFormatting.RED).func_240699_a_(TextFormatting.BOLD), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);

    public RedRoseWarrior(EntityType<? extends RedRoseWarrior> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 10;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        this.bossInfo.func_186758_d(true);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setRRWState(compound.func_74771_c(KEY_STATE));
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 800.0).func_233815_a_(Attributes.field_233821_d_, 0.22).func_233815_a_(Attributes.field_233819_b_, 18.0).func_233815_a_(Attributes.field_233823_f_, 18.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterBending(this, 66, 3, 6));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, StampyLongNose.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SlimeEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, GolemEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, NotBreeBree.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PhantomEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, GhastEntity.class, true));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_STATE, this.getrrwstate());
    }

    public void setRRWState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
    }

    public byte getrrwstate() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    public boolean isNoneState() {
        return this.getrrwstate() == 0;
    }

    public boolean isBendingAttack() {
        return this.getrrwstate() == 2;
    }

    public void setBendingAttack(boolean smash) {
        this.setRRWState(smash ? (byte)2 : 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 9: {
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    protected float func_70647_i() {
        return 0.7f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return true;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (!this.field_70170_p.func_201670_d()) {
            WaterProjectile waterbending = WaterProjectile.create(this.field_70170_p, (LivingEntity)this);
            this.field_70170_p.func_217376_c((Entity)waterbending);
        }
        this.func_184185_a(SoundEvents.field_193779_I, 1.2f, 1.0f);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    class WaterBending
    extends IntervalRangedAttackGoal {
        protected WaterBending(IRangedAttackMob entityIn, int duration, int count, int maxCooldownIn) {
            super(entityIn, duration, count, maxCooldownIn);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && RedRoseWarrior.this.isNoneState();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            RedRoseWarrior.this.setBendingAttack(true);
            RedRoseWarrior.this.func_130014_f_().func_72960_a((Entity)RedRoseWarrior.this, (byte)9);
            RedRoseWarrior.this.func_184185_a(SoundEvents.field_187917_gq, 1.0f, 1.2f);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            RedRoseWarrior.this.setBendingAttack(false);
        }
    }
}

