/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.entity;

import com.devmaster.dangerzone.entity.BaseProjectile;
import com.devmaster.dangerzone.util.RegistryHandler;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class WaterProjectile
extends BaseProjectile {
    public WaterProjectile(EntityType<? extends ProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    protected WaterProjectile(World worldIn, LivingEntity thrower) {
        this((EntityType<? extends ProjectileEntity>)((EntityType)RegistryHandler.WATER_PROJECTILE.get()), worldIn);
        this.lifespan = 80;
        super.func_212361_a((Entity)thrower);
        this.func_70107_b(thrower.func_226277_ct_(), thrower.func_226280_cw_() - 0.1, thrower.func_226281_cx_());
        this.func_234612_a_((Entity)thrower, thrower.field_70125_A, thrower.field_70177_z, 0.0f, 0.78f, 0.85f);
        this.func_70018_K();
    }

    public static WaterProjectile create(World worldIn, LivingEntity thrower) {
        return new WaterProjectile(worldIn, thrower);
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected List<EffectInstance> getPotionEffects(LivingEntity entity) {
        return ImmutableList.of((Object)new EffectInstance(Effects.field_76433_i, 0, 1));
    }

    @Override
    protected IParticleData getImpactParticle(LivingEntity entity) {
        return ParticleTypes.field_218422_X;
    }

    @Override
    protected IParticleData getTrailParticle() {
        return ParticleTypes.field_197618_k;
    }

    @Override
    protected float getImpactDamage(LivingEntity entity) {
        return 5.0f;
    }
}

