/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.items;

import com.devmaster.dangerzone.misc.ArmourEvents;
import com.devmaster.dangerzone.misc.DangerZone;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public class Armour
extends ArmorItem {
    protected static final UUID[] SLOT_ID = new UUID[]{UUID.fromString("16978b34-e8de-48bb-9657-c142422c05e7"), UUID.fromString("87ed54a8-3dc5-44c9-a958-beb7c5b18ecf"), UUID.fromString("5471d8c4-5319-4101-9e56-9db077922ccd"), UUID.fromString("3bf6e6a0-f0ac-4879-9fb2-d800ddcbe348")};
    protected static final UUID MOVEMENT_SPEED = UUID.fromString("27dcaf71-b083-459a-8eca-6d937b129e0d");
    protected static final UUID SWIM_SPEED = UUID.fromString("8cce4d68-479d-4954-8349-10ac59a6a681");
    protected static final UUID GRAVITY = UUID.fromString("3010c57e-d8ba-40d8-bf18-8ae81cde244f");
    protected static final UUID SWING_SPEED = UUID.fromString("cac0fc03-0541-4c70-8266-1955ee5e0c6e");
    protected ArmourEvents event;
    protected Multimap<Attribute, AttributeModifier> modifiers;
    protected float movespeed;
    protected float swimspeed;
    protected float gravity;
    protected float swingspeed;
    protected int setid = -1;
    protected int setpieces = 1;
    private String[] info = new String[0];
    public int durabilityMultiplier;

    public Armour(IArmorMaterial material, EquipmentSlotType slot, Rarity rarity, int durabilityMultiplier) {
        super(material, slot, Armour.get(rarity));
        this.durabilityMultiplier = durabilityMultiplier;
        this.setModifiers(slot);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean currentlyheld) {
        PlayerEntity player;
        int pieces;
        if (this.event != null && this.event.getEventType() == ArmourEvents.EventType.Auto && entity instanceof PlayerEntity && (pieces = this.getEquippedSetPieces(player = (PlayerEntity)entity)) >= this.setpieces && this.event.getCondition().test(player, null, null, stack)) {
            this.event.getAction().accept(player, null, null, stack);
        }
    }

    protected int getEquippedSetPieces(PlayerEntity player) {
        int pieces = 0;
        for (ItemStack piece : player.func_184193_aE()) {
            if (!(piece.func_77973_b() instanceof Armour) || ((Armour)piece.func_77973_b()).getSetID() != this.setid) continue;
            ++pieces;
        }
        return pieces;
    }

    public Armour isSet(int id, int requiredpieces) {
        this.setid = id;
        this.setpieces = requiredpieces;
        return this;
    }

    public int getSetID() {
        return this.setid;
    }

    public Armour addEffect(ArmourEvents event) {
        if (event.getEventType() == ArmourEvents.EventType.Auto) {
            this.event = event;
        } else {
            ArmourEvents.addEvent(event);
        }
        return this;
    }

    public Armour setModifiers(EquipmentSlotType slot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID id = SLOT_ID[slot.func_188454_b()];
        builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(id, "Armor modifier", (double)this.field_200882_e.func_200902_b(slot), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(id, "Armor toughness", (double)this.field_200882_e.func_200901_e(), AttributeModifier.Operation.ADDITION));
        if (this.field_200882_e.func_230304_f_() != 0.0f) {
            builder.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(id, "Armor knockback resistance", (double)this.field_200882_e.func_230304_f_(), AttributeModifier.Operation.ADDITION));
        }
        this.modifiers = builder.build();
        return this;
    }

    public Armour setMoveSpeed(float f) {
        this.movespeed = f;
        return this;
    }

    public Armour setSwimSpeed(float f) {
        this.swimspeed = f;
        return this;
    }

    public Armour setGravity(float f) {
        this.gravity = f;
        return this;
    }

    public Armour setSwingSpeed(float f) {
        this.swingspeed = f;
        return this;
    }

    public Armour rebuildWith(Attribute attribute, UUID id, String modifiername, double value, AttributeModifier.Operation valuetype) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(this.modifiers);
        builder.put((Object)attribute, (Object)new AttributeModifier(id, modifiername, value, valuetype));
        this.modifiers = builder.build();
        return this;
    }

    public Armour rebuild() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(this.modifiers);
        if (this.swingspeed != 0.0f) {
            builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(SWING_SPEED, "Armour modifier", (double)this.swingspeed, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.movespeed != 0.0f) {
            builder.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(MOVEMENT_SPEED, "Armour modifier", (double)this.movespeed, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.swimspeed != 0.0f) {
            builder.put((Object)ForgeMod.SWIM_SPEED.get(), (Object)new AttributeModifier(SWIM_SPEED, "Armour modifier", (double)this.swimspeed, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.gravity != 0.0f) {
            builder.put((Object)ForgeMod.ENTITY_GRAVITY.get(), (Object)new AttributeModifier(GRAVITY, "Armour modifier", (double)this.gravity, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        this.modifiers = builder.build();
        return this;
    }

    protected static final Item.Properties get(Rarity rarity) {
        return new Item.Properties().func_200917_a(1).func_200916_a(DangerZone.ARMOR).func_208103_a(rarity);
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        return slot == this.field_77881_a ? this.modifiers : super.func_111205_h(slot);
    }

    public Armour addInfo(String ... newInfo) {
        if (newInfo != null && newInfo.length > 0) {
            String[] combinedInfo = new String[this.info.length + newInfo.length];
            System.arraycopy(this.info, 0, combinedInfo, 0, this.info.length);
            System.arraycopy(newInfo, 0, combinedInfo, this.info.length, newInfo.length);
            this.info = combinedInfo;
        }
        return this;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        for (String s : this.info) {
            list.add((ITextComponent)new StringTextComponent(s));
        }
    }
}

