/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.items;

import com.devmaster.dangerzone.items.AItem;
import com.devmaster.dangerzone.misc.DangerZone;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.TriConsumer;

public class Consumable
extends AItem {
    private Supplier<SoundEvent> useSoundSupplier;
    protected boolean alwaysEdible = false;
    protected UseAction useaction = UseAction.BOW;
    protected List<EffectInstance> effects;
    protected TriConsumer<World, PlayerEntity, ItemStack> action;
    protected int usetime = 32;
    protected int foodamount;
    protected int repairamount;
    protected int burnTime = 0;
    protected float healamount;
    protected float saturationamount;
    protected float repairpercentage;
    protected boolean repaireverything;
    protected boolean useinstantly;
    protected boolean isMeat = false;

    public Consumable(int stacksize, Rarity rarity, ItemGroup tab) {
        super(new Item.Properties().func_200917_a(stacksize).func_200916_a(tab).func_208103_a(rarity));
    }

    public Consumable(int stacksize) {
        super(stacksize, DangerZone.FOOD);
    }

    public Consumable(int durability, ItemGroup tab, Rarity rarity) {
        super(new Item.Properties().func_200918_c(durability).func_200916_a(tab).func_208103_a(rarity));
    }

    public int getBurnTime(ItemStack itemStack, @Nullable IRecipeType<?> recipeType) {
        return this.burnTime;
    }

    public Consumable setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public Consumable(Item.Properties p) {
        super(p);
    }

    public Consumable setUseSound(Supplier<SoundEvent> soundSupplier) {
        this.useSoundSupplier = soundSupplier;
        return this;
    }

    public Consumable useInstantly() {
        this.useinstantly = true;
        this.usetime = 0;
        return this;
    }

    public Consumable meat() {
        this.isMeat = true;
        return this;
    }

    public Consumable setAlwaysEdible(boolean alwaysEdible) {
        this.alwaysEdible = alwaysEdible;
        return this;
    }

    public boolean func_219971_r() {
        return this.foodamount > 0 || this.isMeat;
    }

    public Food func_219967_s() {
        if (this.func_219971_r()) {
            Food.Builder builder = new Food.Builder();
            if (this.isMeat) {
                builder.func_221451_a();
            }
            return builder.func_221453_d();
        }
        return null;
    }

    public Consumable health(float f) {
        this.healamount = f;
        return this;
    }

    public Consumable hunger(int amount, float saturation) {
        this.foodamount = amount;
        this.saturationamount = saturation;
        return this;
    }

    public Consumable action(UseAction action) {
        this.useaction = action;
        return this;
    }

    public Consumable repair(float amount, boolean percentage) {
        if (percentage) {
            this.repairpercentage = amount;
        } else {
            this.repairamount = (int)amount;
        }
        return this;
    }

    public Consumable effect(TriConsumer<World, PlayerEntity, ItemStack> action) {
        this.action = action;
        return this;
    }

    public Consumable effect(Effect effect, int amp, int seconds, boolean visible) {
        if (this.effects == null) {
            this.effects = new ArrayList<EffectInstance>();
        }
        this.effects.add(new EffectInstance(effect, seconds, amp, !visible, visible));
        return this;
    }

    public void damage(ItemStack stack, LivingEntity e, int i) {
        stack.func_190918_g(i);
    }

    public void doEffect(World world, PlayerEntity player, ItemStack stack) {
        int repairtype;
        if (this.healamount > 0.0f) {
            player.func_70691_i(this.healamount);
        }
        if (this.foodamount > 0 && (this.alwaysEdible || this.healamount > 0.0f && player.func_110143_aJ() < player.func_110138_aP() || player.func_71024_bL().func_75121_c())) {
            player.func_71024_bL().func_75122_a(this.foodamount, this.saturationamount);
        }
        if (this.effects != null) {
            for (EffectInstance i : this.effects) {
                if (i.func_76459_b() == 0) {
                    player.func_195063_d(i.func_188419_a());
                    continue;
                }
                player.func_195064_c(i);
            }
        }
        if (this.action != null) {
            this.action.accept((Object)world, (Object)player, (Object)stack);
        }
        int n = this.repairamount > 0 ? 1 : (repairtype = this.repairpercentage > 0.0f ? 2 : 0);
        if (repairtype > 0) {
            player.field_71071_by.field_70462_a.forEach(is -> {
                if (is.func_77984_f()) {
                    is.func_196085_b((int)Math.min(0.0f, (float)is.func_77952_i() - (repairtype == 1 ? (float)this.repairamount : (float)is.func_77958_k() * this.repairpercentage)));
                }
            });
        }
    }

    public Consumable removeEffect(Effect effect) {
        if (this.effects == null) {
            this.effects = new ArrayList<EffectInstance>();
        }
        this.effects.add(new EffectInstance(effect, 0, 0, false, false));
        return this;
    }

    protected void use(World world, PlayerEntity player, ItemStack stack) {
        SoundEvent sound;
        if (this.useSoundSupplier != null && !world.field_72995_K && (sound = this.useSoundSupplier.get()) != null) {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        this.doEffect(world, player, stack);
        this.damage(stack, (LivingEntity)player, 1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        boolean canEat;
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = canEat = player.func_71024_bL().func_75121_c() || this.alwaysEdible;
        if (canEat) {
            if (this.useinstantly) {
                SoundEvent sound;
                if (this.useSoundSupplier != null && !world.field_72995_K && (sound = this.useSoundSupplier.get()) != null) {
                    world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                this.use(world, player, stack);
                return ActionResult.func_226249_b_((Object)stack);
            }
            player.func_184598_c(hand);
            return ActionResult.func_226249_b_((Object)stack);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            boolean canEat;
            PlayerEntity player = (PlayerEntity)entity;
            boolean bl = canEat = player.func_71024_bL().func_75121_c() || this.alwaysEdible;
            if (canEat) {
                this.use(world, player, stack);
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return this.usetime;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return this.useaction;
    }
}

