/*
 * Decompiled with CFR 0.152.
 */
package com.devmaster.dangerzone.items;

import com.devmaster.dangerzone.misc.DangerZone;
import com.devmaster.dangerzone.util.ModdedTier;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public class Shovel
extends ShovelItem {
    protected static final UUID MOVESPEED = UUID.fromString("35f5b798-7778-4017-98f9-ff557dc28f03");
    protected static final UUID REACH = UUID.fromString("168fad76-3979-4638-91c9-a366c0933551");
    protected String name;
    private String[] info = new String[0];
    protected float reach = 0.0f;
    protected float movespeed = 0.0f;
    protected float attackspeed = 0.0f;
    protected Multimap<Attribute, AttributeModifier> modifiers;
    protected ItemStack repairitem;
    public int durabilityMultiplier;

    public Shovel(ModdedTier tier, int durabilityMultiplier) {
        super((IItemTier)tier, -1.0f, -2.4f, new Item.Properties().func_200916_a(DangerZone.TOOLS));
        this.repairitem = tier.getRepairItem();
        this.durabilityMultiplier = durabilityMultiplier;
    }

    public Shovel build(float reach, float movespeed) {
        this.reach = reach;
        this.movespeed = movespeed;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Shovel modifier", (double)this.func_234675_d_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Shovel modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.modifiers = builder.build();
        return this;
    }

    public Shovel rebuild() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(this.modifiers);
        if (this.movespeed != 0.0f) {
            builder.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(MOVESPEED, "Shovel modifier", (double)this.movespeed, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.reach != 0.0f) {
            builder.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(REACH, "Shovel modifier", (double)this.reach, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        this.modifiers = builder.build();
        return this;
    }

    public Shovel rebuildWith(Attribute attribute, UUID id, String modifiername, double value, AttributeModifier.Operation valuetype) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(this.modifiers);
        builder.put((Object)attribute, (Object)new AttributeModifier(id, modifiername, value, valuetype));
        this.modifiers = builder.build();
        return this;
    }

    public Shovel addInfo(String ... newInfo) {
        if (newInfo != null && newInfo.length > 0) {
            String[] combinedInfo = new String[this.info.length + newInfo.length];
            System.arraycopy(this.info, 0, combinedInfo, 0, this.info.length);
            System.arraycopy(newInfo, 0, combinedInfo, this.info.length, newInfo.length);
            this.info = combinedInfo;
        }
        return this;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        for (String s : this.info) {
            list.add((ITextComponent)new StringTextComponent(s));
        }
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        if (slot == EquipmentSlotType.MAINHAND) {
            return this.modifiers;
        }
        return super.func_111205_h(slot);
    }
}

